/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.sql.Blob;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ExternalElementType
implements ElementType {
    public static final ElementType INSTANCE = new ExternalElementType();
    private transient ElementMetaData elementType;
    private static final Log logger = LogFactory.getLog(ExternalElementType.class);

    public void configureDesignTimeDefaults(Element element, Locale locale) {
    }

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("external-element-field");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue != null) {
            return staticValue;
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Object filteredValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object value = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (value != null && (filteredValue = this.filter(runtime, element, value)) != null) {
            return filteredValue;
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        return this.filter(runtime, element, nullValue);
    }

    private Object filter(ExpressionRuntime runtime, Element element, Object value) {
        if (value instanceof Element) {
            return value;
        }
        try {
            Resource resource;
            Object resourceContent;
            Class target;
            ResourceKey key;
            ResourceKey contentBase = runtime.getProcessingContext().getContentBase();
            ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
            if (value instanceof ResourceKey) {
                key = (ResourceKey)value;
            } else if (value instanceof Blob) {
                Blob b = (Blob)value;
                byte[] data = IOUtils.getInstance().readBlob(b);
                key = resManager.createKey((Object)data);
            } else if (value instanceof String) {
                Object baseURL = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
                if (baseURL != null) {
                    ResourceKey baseKey = resManager.createKey(baseURL);
                    key = resManager.deriveKey(baseKey, (String)value);
                } else {
                    key = resManager.deriveKey(contentBase, (String)value);
                }
            } else {
                key = resManager.createKey(value);
            }
            if (key == null) {
                return null;
            }
            Object targetRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "target-type");
            if (targetRaw instanceof String) {
                ClassLoader loader = ObjectUtilities.getClassLoader(ExternalElementType.class);
                target = Class.forName((String)targetRaw, false, loader);
                if (target == null) {
                    return null;
                }
            } else {
                target = SubReport.class;
            }
            if ((resourceContent = (resource = resManager.create(key, contentBase, target)).getResource()) instanceof Element) {
                return resourceContent;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to load content using value " + value), (Throwable)e);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

