/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public class MessageType
implements ElementType {
    private MessageFormatFilter messageFormatFilter = new MessageFormatFilter();
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("message");
        }
        return this.elementType;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        Object message = ElementTypeUtils.queryStaticValue(element);
        if (message == null) {
            return nullValue;
        }
        this.messageFormatFilter.setFormatString(String.valueOf(message));
        Object messageNullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "message-null-value");
        if (messageNullValue != null) {
            this.messageFormatFilter.setNullString(String.valueOf(messageNullValue));
        } else if (nullValue != null) {
            this.messageFormatFilter.setNullString(String.valueOf(nullValue));
        } else {
            this.messageFormatFilter.setNullString(null);
        }
        Object value = this.messageFormatFilter.getValue(runtime, element);
        if (value == null) {
            return nullValue;
        }
        return String.valueOf(value);
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object message = ElementTypeUtils.queryStaticValue(element);
        if (message == null) {
            return null;
        }
        return message;
    }

    public Object clone() throws CloneNotSupportedException {
        MessageType clone = (MessageType)super.clone();
        if (clone.messageFormatFilter != null) {
            clone.messageFormatFilter = (MessageFormatFilter)this.messageFormatFilter.clone();
        }
        return clone;
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", "Message");
    }
}

