/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public class NumberFieldType
implements ElementType,
RawDataSource {
    private static final String DECIMALFORMAT_DEFAULT_PATTERN = "#,###.##############################################################################################################################################################################################################################";
    private transient ElementMetaData elementType;
    private transient FastDecimalFormat decimalFormat;
    private transient Locale locale;
    private transient String formatString;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("number-field");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue instanceof Number) {
            Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
            if (formatStringRaw == null || "".equals(formatStringRaw)) {
                formatStringRaw = DECIMALFORMAT_DEFAULT_PATTERN;
            }
            try {
                Locale locale = runtime.getResourceBundleFactory().getLocale();
                FastDecimalFormat decimalFormat = new FastDecimalFormat(String.valueOf(formatStringRaw), locale);
                return decimalFormat.format(staticValue);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    public Object getRawValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Number)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        return retval;
    }

    public FormatSpecification getFormatString(ExpressionRuntime runtime, Element element, FormatSpecification formatSpecification) {
        Object formatStringRaw;
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        if ((formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string")) != null) {
            formatSpecification.redefine(2, String.valueOf(formatStringRaw));
        }
        return formatSpecification;
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Number)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
        if (formatStringRaw == null || "".equals(formatStringRaw)) {
            formatStringRaw = DECIMALFORMAT_DEFAULT_PATTERN;
        }
        try {
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            if (this.decimalFormat == null) {
                this.formatString = String.valueOf(formatStringRaw);
                this.locale = locale;
                this.decimalFormat = new FastDecimalFormat(this.formatString, locale);
            } else {
                if (!ObjectUtilities.equal((Object)this.formatString, (Object)formatStringRaw)) {
                    this.formatString = String.valueOf(formatStringRaw);
                    this.decimalFormat.applyPattern(this.formatString);
                }
                if (!ObjectUtilities.equal((Object)this.locale, (Object)locale)) {
                    this.locale = locale;
                    this.decimalFormat.setLocale(locale);
                }
            }
            return this.decimalFormat.format(retval);
        }
        catch (Exception e) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NumberFieldType o = (NumberFieldType)super.clone();
        if (o.decimalFormat != null) {
            o.decimalFormat = (FastDecimalFormat)this.decimalFormat.clone();
        }
        return o;
    }
}

