/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.StringUtil;

public class RectangleType
implements ElementType {
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("rectangle");
        }
        return this.elementType;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        float arcWidth = this.parseArcParam(element, "arc-width");
        float arcHeight = this.parseArcParam(element, "arc-height");
        if (arcWidth <= 0.0f || arcHeight <= 0.0f) {
            return new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        }
        return new RoundRectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f, arcWidth, arcHeight);
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        return this.getValue(runtime, element);
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
        element.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
        element.getStyle().setStyleProperty(ElementStyleKeys.DRAW_SHAPE, Boolean.TRUE);
    }

    private float parseArcParam(Element element, String attrName) {
        float arcWidth;
        Object attributeArcWidth = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", attrName);
        if (attributeArcWidth != null) {
            if (attributeArcWidth instanceof Number) {
                Number n = (Number)attributeArcWidth;
                arcWidth = n.floatValue();
            } else {
                arcWidth = StringUtil.parseFloat(String.valueOf(attributeArcWidth), 0.0f);
            }
        } else {
            arcWidth = 0.0f;
        }
        return arcWidth;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

