/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public class ResourceLabelType
implements ElementType {
    private static final Log logger = LogFactory.getLog(ResourceLabelType.class);
    public static final ResourceLabelType INSTANCE = new ResourceLabelType();
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("resource-label");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object resourceKeyRaw = ElementTypeUtils.queryStaticValue(element);
        String resourceKey = resourceKeyRaw == null ? "<null>" : resourceKeyRaw.toString();
        return resourceKey;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object resourceKeyRaw = ElementTypeUtils.queryStaticValue(element);
        if (resourceKeyRaw == null) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        String resourceKey = String.valueOf(resourceKeyRaw);
        String resourceId = ElementTypeUtils.queryResourceId(runtime, element);
        if (resourceId == null) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        try {
            ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
            ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
            if (bundle != null) {
                return bundle.getString(resourceKey);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to retrive the value for resource-bundle " + resourceId + " with key " + resourceKey));
        }
        return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
    }
}

