/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.ResourceMessageFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public class ResourceMessageType
implements ElementType {
    private ResourceMessageFormatFilter messageFormatFilter = new ResourceMessageFormatFilter();
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("resource-message");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object resourceMessageRaw = ElementTypeUtils.queryStaticValue(element);
        String resourceKey = resourceMessageRaw == null ? "<null>" : resourceMessageRaw.toString();
        return resourceKey;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        Object message = ElementTypeUtils.queryStaticValue(element);
        if (message == null) {
            return nullValue;
        }
        Object resourceId = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-identifier");
        if (resourceId == null) {
            return nullValue;
        }
        this.messageFormatFilter.setFormatKey(String.valueOf(message));
        this.messageFormatFilter.setResourceIdentifier(String.valueOf(resourceId));
        Object messageNullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "message-null-value");
        if (messageNullValue != null) {
            this.messageFormatFilter.setNullString(String.valueOf(messageNullValue));
        } else if (nullValue != null) {
            this.messageFormatFilter.setNullString(String.valueOf(nullValue));
        } else {
            this.messageFormatFilter.setNullString(null);
        }
        Object value = this.messageFormatFilter.getValue(runtime, element);
        if (value == null) {
            return nullValue;
        }
        return String.valueOf(value);
    }

    public Object clone() throws CloneNotSupportedException {
        ResourceMessageType clone = (ResourceMessageType)super.clone();
        if (clone.messageFormatFilter != null) {
            clone.messageFormatFilter = (ResourceMessageFormatFilter)this.messageFormatFilter.clone();
        }
        return clone;
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
    }
}

