/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportState;

public abstract class AbstractElementFormatFunction
extends AbstractFunction
implements PageEventListener,
LayoutProcessorFunction {
    private String element;

    protected AbstractElementFormatFunction() {
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getElement() {
        return this.element;
    }

    public void itemsStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportDefinition definition = event.getReport();
        this.processRootBand(definition.getNoDataBand());
        this.processRootBand(definition.getDetailsHeader());
        this.processFooterBands(event.getState());
    }

    public void itemsAdvanced(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ItemBand b = event.getReport().getItemBand();
        this.processRootBand(b);
        this.processFooterBands(event.getState());
    }

    public void itemsFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportDefinition definition = event.getReport();
        this.processRootBand(definition.getDetailsFooter());
        this.processFooterBands(event.getState());
    }

    public void reportInitialized(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        boolean slottedHeaderMode = "slotted".equals(this.getRuntime().getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.HeaderPageBandMode", "slotted"));
        if (slottedHeaderMode) {
            PageHeader b = event.getReport().getPageHeader();
            this.processRootBand(b);
        }
    }

    public void reportFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportFooter b = event.getReport().getReportFooter();
        this.processRootBand(b);
        this.processFooterBands(event.getState());
    }

    public void reportStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportHeader b = event.getReport().getReportHeader();
        this.processRootBand(b);
        this.processFooterBands(event.getState());
    }

    protected void processGroup(Group group) {
        GroupHeader b = group.getHeader();
        this.processRootBand(b);
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        Group group = FunctionUtilities.getCurrentGroup(event);
        this.processGroup(group);
        this.processFooterBands(event.getState());
    }

    public void groupFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        GroupFooter b = FunctionUtilities.getCurrentGroup(event).getFooter();
        this.processRootBand(b);
        this.processFooterBands(event.getState());
    }

    public void pageFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        PageFooter b = event.getReport().getPageFooter();
        this.processRootBand(b);
    }

    public void pageStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        PageHeader b = event.getReport().getPageHeader();
        this.processRootBand(b);
        Watermark w = event.getReport().getWatermark();
        this.processRootBand(w);
        this.processFooterBands(event.getState());
    }

    protected void processFooterBands(ReportState state) {
        while (state != null) {
            ReportDefinition reportDefinition = state.getReport();
            this.processRootBand(reportDefinition.getPageFooter());
            this.processRootBand(reportDefinition.getDetailsFooter());
            Group g = reportDefinition.getRootGroup();
            while (g != null) {
                this.processRootBand(g.getFooter());
                GroupBody body = g.getBody();
                if (!(body instanceof SubGroupBody)) break;
                SubGroupBody sgb = (SubGroupBody)body;
                g = sgb.getGroup();
            }
            state = state.getParentSubReportState();
        }
    }

    protected abstract void processRootBand(Band var1);

    public Object getValue() {
        return null;
    }
}

