/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class AverageExpression
extends AbstractExpression {
    private ArrayList fieldList = new ArrayList();
    private int scale = 14;
    private int roundingMode = 4;
    private static final BigDecimal ZERO = new BigDecimal("0");

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public Object getValue() {
        Number[] values = this.collectValues();
        BigDecimal total = ZERO;
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            Number n = values[i];
            if (n == null) continue;
            total = total.add(new BigDecimal(n.toString()));
            ++count;
        }
        if (count > 0) {
            return total.divide(new BigDecimal(String.valueOf(count)), this.scale, this.roundingMode);
        }
        return ZERO;
    }

    private Number[] collectValues() {
        Number[] retval = new Number[this.fieldList.size()];
        for (int i = 0; i < this.fieldList.size(); ++i) {
            String field = (String)this.fieldList.get(i);
            Object o = this.getDataRow().get(field);
            if (!(o instanceof Number)) continue;
            retval[i] = (Number)o;
        }
        return retval;
    }

    public Expression getInstance() {
        AverageExpression ae = (AverageExpression)super.getInstance();
        ae.fieldList = (ArrayList)this.fieldList.clone();
        return ae;
    }

    public String[] getField() {
        return this.fieldList.toArray(new String[this.fieldList.size()]);
    }

    public void setField(String[] fields) {
        this.fieldList.clear();
        this.fieldList.addAll(Arrays.asList(fields));
    }

    public String getField(int index) {
        return (String)this.fieldList.get(index);
    }

    public void setField(int index, String field) {
        if (this.fieldList.size() == index) {
            this.fieldList.add(field);
        } else {
            this.fieldList.set(index, field);
        }
    }

    public int getFieldCount() {
        return this.fieldList.size();
    }
}

