/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public abstract class ColumnAggregationExpression
extends AbstractExpression {
    private ArrayList fields = new ArrayList();
    private transient Object[] fieldValues;

    protected ColumnAggregationExpression() {
    }

    protected Object[] getFieldValues() {
        int size = this.fields.size();
        if (this.fieldValues == null || this.fieldValues.length != size) {
            this.fieldValues = new Object[size];
        }
        DataRow dataRow = this.getDataRow();
        for (int i = 0; i < size; ++i) {
            String field = (String)this.fields.get(i);
            if (field == null) continue;
            this.fieldValues[i] = dataRow.get(field);
        }
        return this.fieldValues;
    }

    public void setField(int index, String field) {
        if (this.fields.size() == index) {
            this.fields.add(field);
        } else {
            this.fields.set(index, field);
        }
        this.fieldValues = null;
    }

    public String getField(int index) {
        return (String)this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String[] getField() {
        return this.fields.toArray(new String[this.fields.size()]);
    }

    public void setField(String[] fields) {
        this.fields.clear();
        this.fields.addAll(Arrays.asList(fields));
        this.fieldValues = null;
    }

    public Expression getInstance() {
        ColumnAggregationExpression cae = (ColumnAggregationExpression)super.getInstance();
        cae.fields = (ArrayList)this.fields.clone();
        return cae;
    }
}

