/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.function.ColumnAggregationExpression;

public class ColumnAverageExpression
extends ColumnAggregationExpression {
    private boolean onlyValidFields;
    private boolean returnInfinity = true;
    private int scale = 14;
    private int roundingMode = 4;

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isReturnInfinity() {
        return this.returnInfinity;
    }

    public void setReturnInfinity(boolean returnInfinity) {
        this.returnInfinity = returnInfinity;
    }

    public boolean isOnlyValidFields() {
        return this.onlyValidFields;
    }

    public void setOnlyValidFields(boolean onlyValidFields) {
        this.onlyValidFields = onlyValidFields;
    }

    public Object getValue() {
        Object[] values = this.getFieldValues();
        BigDecimal computedResult = new BigDecimal(0);
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (!(value instanceof Number)) continue;
            Number n = (Number)value;
            BigDecimal nval = new BigDecimal(n.toString());
            computedResult = computedResult.add(nval);
            ++count;
        }
        if (this.onlyValidFields) {
            if (count == 0) {
                if (!this.returnInfinity) {
                    return null;
                }
                if (computedResult.signum() == -1) {
                    return new Double(Double.NEGATIVE_INFINITY);
                }
                return new Double(Double.POSITIVE_INFINITY);
            }
            return computedResult.divide(new BigDecimal(count), this.scale, this.roundingMode);
        }
        if (values.length == 0) {
            if (!this.returnInfinity) {
                return null;
            }
            if (computedResult.signum() == -1) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            return new Double(Double.POSITIVE_INFINITY);
        }
        return computedResult.divide(new BigDecimal(values.length), this.scale, this.roundingMode);
    }
}

