/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ConvertToNumberExpression
extends AbstractExpression {
    private static final String DECIMALFORMAT_DEFAULT_PATTERN = "#,###.####################################################################################################################################################################################################################################################################################################################################################";
    private static final BigDecimal ZERO = new BigDecimal(0);
    private String field;
    private String format;
    private Locale locale;
    private Locale lastLocale;
    private DecimalFormat decimalFormat;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.lastLocale = null;
        this.decimalFormat = null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.lastLocale = null;
        this.decimalFormat = null;
    }

    public Object getValue() {
        DataRow dataRow = this.getDataRow();
        Object o = dataRow.get(this.field);
        if (o instanceof Number) {
            return o;
        }
        String formatString = this.getFormat();
        try {
            Locale localeUsed = this.locale;
            if (localeUsed == null) {
                localeUsed = this.getResourceBundleFactory().getLocale();
            }
            if (this.decimalFormat == null || !ObjectUtilities.equal((Object)this.lastLocale, (Object)localeUsed)) {
                String effectiveFormatString = formatString == null || formatString.length() == 0 ? DECIMALFORMAT_DEFAULT_PATTERN : formatString;
                this.lastLocale = localeUsed;
                this.decimalFormat = new DecimalFormat(effectiveFormatString);
                this.activateBigDecimalMode(this.decimalFormat);
                this.decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(localeUsed));
            }
            return this.decimalFormat.parse(String.valueOf(o));
        }
        catch (ParseException e) {
            return ZERO;
        }
    }

    private void activateBigDecimalMode(DecimalFormat format) {
        if (ObjectUtilities.isJDK14()) {
            try {
                Method method = DecimalFormat.class.getMethod("setParseBigDecimal", Boolean.TYPE);
                method.invoke((Object)format, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

