/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class CountDistinctFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private transient HashSet values = new HashSet();
    private String group;
    private String field;

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void reportInitialized(ReportEvent event) {
        this.values.clear();
    }

    public void groupStarted(ReportEvent event) {
        if (this.getField() == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        this.values.clear();
    }

    public void itemsAdvanced(ReportEvent event) {
        if (this.getField() == null) {
            return;
        }
        Object o = event.getDataRow().get(this.getField());
        this.values.add(o);
    }

    public Object getValue() {
        return IntegerCache.getInteger(this.values.size());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.values = new HashSet();
    }

    public Expression getInstance() {
        CountDistinctFunction expression = (CountDistinctFunction)super.getInstance();
        expression.values = new HashSet();
        return expression;
    }

    public Object clone() throws CloneNotSupportedException {
        CountDistinctFunction o = (CountDistinctFunction)super.clone();
        o.values = (HashSet)this.values.clone();
        return o;
    }
}

