/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.Anchor;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class CreateGroupAnchorsFunction
extends AbstractFunction {
    private String group;
    private String anchorPrefix = "anchor";
    private Anchor anchor;
    private int count;

    public String getAnchorPrefix() {
        return this.anchorPrefix;
    }

    public void setAnchorPrefix(String anchorPrefix) {
        if (anchorPrefix == null) {
            throw new NullPointerException("The Anchor-Prefix must not be null.");
        }
        this.anchorPrefix = anchorPrefix;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void reportInitialized(ReportEvent event) {
        this.count = 0;
        StringBuilder targetBuffer = new StringBuilder();
        String prefix = this.getAnchorPrefix();
        targetBuffer.append(prefix);
        targetBuffer.append(this.getGroup());
        targetBuffer.append("%3D");
        targetBuffer.append(this.count);
        this.anchor = new Anchor(targetBuffer.toString());
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        StringBuilder targetBuffer = new StringBuilder();
        String prefix = this.getAnchorPrefix();
        targetBuffer.append(prefix);
        targetBuffer.append(this.getGroup());
        targetBuffer.append("%3D");
        targetBuffer.append(this.count);
        this.anchor = new Anchor(targetBuffer.toString());
    }

    public Object getValue() {
        return this.anchor;
    }
}

