/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ElementTrafficLightFunction
extends AbstractElementFormatFunction {
    private boolean useOppositeLogic;
    private boolean useAbsoluteValue;
    private boolean defineBackground;
    private String field;
    private Color defaultColor;
    private ArrayList limits = new ArrayList();
    private transient LightDefinition[] lightDefArray;

    public ElementTrafficLightFunction() {
        this.defaultColor = Color.red;
    }

    private void configureDefaultBehaviour() {
        if (this.limits.isEmpty()) {
            this.limits.add(new LightDefinition(new Integer(50), Color.yellow));
            this.limits.add(new LightDefinition(new Integer(75), Color.green));
            this.lightDefArray = null;
        }
    }

    public boolean isUseAbsoluteValue() {
        return this.useAbsoluteValue;
    }

    public void setUseAbsoluteValue(boolean useAbsoluteValue) {
        this.useAbsoluteValue = useAbsoluteValue;
    }

    public boolean isUseOppositeLogic() {
        return this.useOppositeLogic;
    }

    public void setUseOppositeLogic(boolean useOppositeLogic) {
        this.useOppositeLogic = useOppositeLogic;
    }

    public void setColor(int index, Color color) {
        if (this.limits.size() == index) {
            LightDefinition ldef = new LightDefinition(null, color);
            this.limits.add(ldef);
            this.lightDefArray = null;
        } else {
            LightDefinition ldef = (LightDefinition)this.limits.get(index);
            if (ldef == null) {
                LightDefinition newdef = new LightDefinition(null, color);
                this.limits.set(index, newdef);
                this.lightDefArray = null;
            } else {
                LightDefinition newdef = new LightDefinition(ldef.getLimit(), color);
                this.limits.set(index, newdef);
                this.lightDefArray = null;
            }
        }
    }

    public Color getColor(int index) {
        LightDefinition ldef = (LightDefinition)this.limits.get(index);
        if (ldef == null) {
            return null;
        }
        return ldef.getColor();
    }

    public int getColorCount() {
        return this.limits.size();
    }

    public Color[] getColor() {
        Color[] retval = new Color[this.limits.size()];
        for (int i = 0; i < this.limits.size(); ++i) {
            LightDefinition definition = (LightDefinition)this.limits.get(i);
            retval[i] = definition.getColor();
        }
        return retval;
    }

    public void setColor(Color[] colors) {
        for (int i = 0; i < colors.length; ++i) {
            Color color = colors[i];
            this.setColor(i, color);
        }
        int size = this.limits.size();
        if (size > colors.length) {
            for (int i = size - 1; i >= colors.length; --i) {
                this.limits.remove(i);
            }
        }
        this.lightDefArray = null;
    }

    public void setLimit(int index, Number value) {
        if (this.limits.size() == index) {
            LightDefinition ldef = new LightDefinition(value, null);
            this.limits.add(ldef);
        } else {
            LightDefinition ldef = (LightDefinition)this.limits.get(index);
            if (ldef == null) {
                LightDefinition newdef = new LightDefinition(value, null);
                this.limits.set(index, newdef);
            } else {
                LightDefinition newdef = new LightDefinition(value, ldef.getColor());
                this.limits.set(index, newdef);
            }
        }
        this.lightDefArray = null;
    }

    public Number getLimit(int index) {
        LightDefinition ldef = (LightDefinition)this.limits.get(index);
        if (ldef == null) {
            return null;
        }
        return ldef.getLimit();
    }

    public int getLimitCount() {
        return this.limits.size();
    }

    public Number[] getLimit() {
        Number[] retval = new Number[this.limits.size()];
        for (int i = 0; i < this.limits.size(); ++i) {
            LightDefinition definition = (LightDefinition)this.limits.get(i);
            retval[i] = definition.getLimit();
        }
        return retval;
    }

    public void setLimit(Number[] limits) {
        for (int i = 0; i < limits.length; ++i) {
            Number limit = limits[i];
            this.setLimit(i, limit);
        }
        int size = this.limits.size();
        if (size > limits.length) {
            for (int i = size - 1; i >= limits.length; --i) {
                this.limits.remove(i);
            }
        }
        this.lightDefArray = null;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public boolean isDefineBackground() {
        return this.defineBackground;
    }

    public void setDefineBackground(boolean defineBackground) {
        this.defineBackground = defineBackground;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    protected void processRootBand(Band b) {
        this.configureDefaultBehaviour();
        Element[] elements = FunctionUtilities.findAllElements(b, this.getElement());
        if (elements.length == 0) {
            return;
        }
        Color color = this.computeColor();
        for (int i = 0; i < elements.length; ++i) {
            if (this.defineBackground) {
                elements[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, color);
                continue;
            }
            elements[i].getStyle().setStyleProperty(ElementStyleKeys.PAINT, color);
        }
    }

    private Color computeColor() {
        Color returnColor;
        Number value;
        if (this.field == null) {
            return this.defaultColor;
        }
        Object o = this.getDataRow().get(this.field);
        if (!(o instanceof Number)) {
            return this.defaultColor;
        }
        Number n = (Number)o;
        if (this.useAbsoluteValue) {
            BigDecimal td;
            if (n instanceof BigDecimal) {
                td = (BigDecimal)n;
                value = td.abs();
            } else {
                td = new BigDecimal(n.toString());
                value = td.abs();
            }
        } else {
            value = n;
        }
        if (this.lightDefArray == null) {
            this.lightDefArray = this.limits.toArray(new LightDefinition[this.limits.size()]);
            Arrays.sort(this.lightDefArray);
        }
        if (this.useOppositeLogic) {
            if (this.limits.isEmpty()) {
                return this.defaultColor;
            }
            returnColor = this.defaultColor;
            for (int i = this.lightDefArray.length - 1; i >= 0; --i) {
                Number limit;
                LightDefinition definition = this.lightDefArray[i];
                if (definition == null || (limit = definition.getLimit()) == null || !(value.doubleValue() < limit.doubleValue())) continue;
                returnColor = definition.getColor();
            }
            if (returnColor == null) {
                return this.defaultColor;
            }
            return returnColor;
        }
        returnColor = this.defaultColor;
        for (int i = 0; i < this.lightDefArray.length; ++i) {
            Number limit;
            LightDefinition definition = this.lightDefArray[i];
            if (definition == null || (limit = definition.getLimit()) == null || !(value.doubleValue() >= limit.doubleValue())) continue;
            returnColor = definition.getColor();
        }
        if (returnColor == null) {
            return this.defaultColor;
        }
        return returnColor;
    }

    public Expression getInstance() {
        try {
            ElementTrafficLightFunction elf = (ElementTrafficLightFunction)super.getInstance();
            elf.limits = (ArrayList)this.limits.clone();
            for (int i = 0; i < this.limits.size(); ++i) {
                LightDefinition definition = (LightDefinition)this.limits.get(i);
                elf.limits.set(i, definition.clone());
            }
            if (this.lightDefArray != null) {
                elf.lightDefArray = (LightDefinition[])this.lightDefArray.clone();
            }
            return elf;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone must always be supported.");
        }
    }

    private static class LightDefinition
    implements Comparable,
    Serializable,
    Cloneable {
        private Color color;
        private Number limit;

        protected LightDefinition(Number limit, Color color) {
            this.limit = limit;
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public Number getLimit() {
            return this.limit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightDefinition that = (LightDefinition)o;
            if (!ObjectUtilities.equal((Object)this.color, (Object)that.color)) {
                return false;
            }
            return ObjectUtilities.equal((Object)this.limit, (Object)that.limit);
        }

        public int hashCode() {
            int result = 0;
            if (this.color != null) {
                result += this.color.hashCode();
            }
            result = this.limit != null ? 31 * result + this.limit.hashCode() : 31 * result;
            return result;
        }

        public int compareTo(Object o) {
            double otherValue;
            LightDefinition ldef = (LightDefinition)o;
            Number myLimit = this.getLimit();
            Number otherLimit = ldef.getLimit();
            if (myLimit == null && otherLimit == null) {
                return 0;
            }
            if (myLimit == null) {
                return 1;
            }
            if (otherLimit == null) {
                return -1;
            }
            double myValue = myLimit.doubleValue();
            if (myValue < (otherValue = otherLimit.doubleValue())) {
                return -1;
            }
            if (myValue > otherValue) {
                return 1;
            }
            return 0;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

