/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;

public class ElementVisibilitySwitchFunction
extends AbstractFunction
implements PageEventListener,
LayoutProcessorFunction {
    private transient boolean trigger;
    private transient int count;
    private Boolean newPageState;
    private int numberOfElements = 1;
    private String element;
    private boolean initialState;
    private boolean resetOnGroupStart = true;
    private boolean resetOnPageStart = true;

    public void pageStarted(ReportEvent event) {
        if (this.resetOnPageStart) {
            this.trigger = this.newPageState == null ? this.getInitialState() : this.newPageState.booleanValue();
            this.count = 0;
            this.triggerVisibleState(event);
        }
    }

    public void pageFinished(ReportEvent event) {
    }

    public void reportInitialized(ReportEvent event) {
        this.trigger = !this.getInitialState();
        this.count = 0;
    }

    public void itemsStarted(ReportEvent event) {
        if (this.resetOnGroupStart) {
            this.trigger = !this.getInitialState();
            this.count = 0;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        this.triggerVisibleState(event);
    }

    private void triggerVisibleState(ReportEvent event) {
        if (this.count % this.numberOfElements == 0) {
            this.trigger = !this.trigger;
        }
        ++this.count;
        if (this.element == null) {
            return;
        }
        ItemBand itemBand = event.getReport().getItemBand();
        Element[] e = FunctionUtilities.findAllElements(itemBand, this.getElement());
        if (e.length > 0) {
            for (int i = 0; i < e.length; ++i) {
                e[i].setVisible(this.trigger);
            }
        }
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public boolean getInitialTriggerValue() {
        return this.initialState;
    }

    public boolean getInitialState() {
        return this.initialState;
    }

    public void setInitialState(boolean initialState) {
        this.initialState = initialState;
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getElement() {
        return this.element;
    }

    public Boolean getNewPageState() {
        return this.newPageState;
    }

    public void setNewPageState(Boolean newPageState) {
        this.newPageState = newPageState;
    }

    public Object getValue() {
        if (this.trigger) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

