/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;

public final class FormulaFunction
extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(FormulaFunction.class);
    private transient Formula compiledFormula;
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;
    private String initialNamespace;
    private String initialExpression;
    private String initial;
    private boolean initialized;
    private boolean formulaError;

    private FormulaContext getFormulaContext() {
        ProcessingContext globalContext = this.getRuntime().getProcessingContext();
        return globalContext.getFormulaContext();
    }

    public String getInitial() {
        return this.initial;
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }

    public String getInitialNamespace() {
        return this.initialNamespace;
    }

    public void setInitial(String initial) {
        this.initial = initial;
        if (initial == null) {
            this.initialNamespace = null;
            this.initialExpression = null;
        } else {
            int separator;
            if (initial.endsWith(";")) {
                logger.warn((Object)"A initial-formula with a trailing semicolon is not valid. Auto-correcting the initial-formula.");
                initial = initial.substring(0, initial.length() - 1);
            }
            if ((separator = initial.indexOf(58)) <= 0 || separator + 1 == initial.length()) {
                if (this.formula.length() > 0 && this.formula.charAt(0) == '=') {
                    this.initialNamespace = "report";
                    this.initialExpression = initial.substring(1);
                } else {
                    this.initialNamespace = null;
                    this.initialExpression = null;
                }
            } else {
                this.initialNamespace = initial.substring(0, separator);
                this.initialExpression = initial.substring(separator + 1);
            }
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.initialized = false;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String formula) {
        this.formula = formula;
        if (formula == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            int separator = formula.indexOf(58);
            if (separator <= 0 || separator + 1 == formula.length()) {
                if (formula.length() > 0 && formula.charAt(0) == '=') {
                    this.formulaNamespace = "report";
                    this.formulaExpression = formula.substring(1);
                } else {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                }
            } else {
                this.formulaNamespace = formula.substring(0, separator);
                this.formulaExpression = formula.substring(separator + 1);
            }
        }
        this.compiledFormula = null;
        this.formulaError = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object computeInitialValue() {
        if (this.initial == null) return this.computeRegularValue();
        ExpressionRuntime expressionRuntime = this.getRuntime();
        Formula initFormula = new Formula(this.initialExpression);
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), expressionRuntime);
        try {
            initFormula.initialize((FormulaContext)context);
            Object object = initFormula.evaluate();
            context.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.close();
                throw throwable;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) return null;
                Configuration config = this.getReportConfiguration();
                if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.function.LogFormulaFailureCause"))) {
                    logger.debug((Object)("Failed to compute the initial value [" + this.formulaExpression + ']'), (Throwable)e);
                    return null;
                } else {
                    logger.debug((Object)("Failed to compute the initial value [" + this.formulaExpression + ']'));
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeRegularValue() {
        if (this.formulaError) {
            return null;
        }
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ExpressionRuntime expressionRuntime = this.getRuntime();
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), expressionRuntime);
        try {
            this.compiledFormula.initialize((FormulaContext)context);
            Object object = this.compiledFormula.evaluate();
            context.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.close();
                throw throwable;
            }
            catch (Exception e) {
                this.formulaError = true;
                if (logger.isDebugEnabled()) {
                    Configuration config = this.getReportConfiguration();
                    if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.function.LogFormulaFailureCause"))) {
                        logger.debug((Object)("Failed to compute the regular value [" + this.formulaExpression + ']'), (Throwable)e);
                    } else {
                        logger.debug((Object)("Failed to compute the regular value [" + this.formulaExpression + ']'));
                    }
                }
                return null;
            }
        }
    }

    public Object getValue() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                return this.computeInitialValue();
            }
            return this.computeRegularValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaFunction o = (FormulaFunction)super.clone();
        if (this.compiledFormula != null) {
            o.compiledFormula = (Formula)this.compiledFormula.clone();
        }
        return o;
    }
}

