/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class FunctionUtilities {
    private FunctionUtilities() {
    }

    public static Element findElement(Band band, String element) {
        if (element == null) {
            throw new NullPointerException("Element name must not be null");
        }
        if (band == null) {
            throw new NullPointerException("Band must not be null");
        }
        if (band.getName().equals(element)) {
            return band;
        }
        Element[] elements = band.getElementArray();
        for (int i = 0; i < elements.length; ++i) {
            Element retval;
            Element e = elements[i];
            if (element.equals(e.getName())) {
                return e;
            }
            if (!(e instanceof Band) || (retval = FunctionUtilities.findElement((Band)e, element)) == null) continue;
            return retval;
        }
        return null;
    }

    public static ReportElement findElementById(ReportDefinition reportDefinition, String id) {
        if (reportDefinition == null) {
            throw new NullPointerException("Element name must not be null");
        }
        if (id == null) {
            return null;
        }
        return FunctionUtilities.findElementById((Section)((Object)reportDefinition), id);
    }

    public static ReportElement findElementByInstanceId(ReportDefinition reportDefinition, InstanceID id) {
        if (reportDefinition == null) {
            throw new NullPointerException("Element name must not be null");
        }
        if (id == null) {
            return null;
        }
        return FunctionUtilities.findElementByInstanceId((Section)((Object)reportDefinition), id);
    }

    public static ReportElement findElementById(Section band, String id) {
        if (band == null) {
            throw new NullPointerException("Element name must not be null");
        }
        if (id == null) {
            return null;
        }
        if (ObjectUtilities.equal((Object)band.getId(), (Object)id)) {
            return band;
        }
        for (int i = 0; i < band.getElementCount(); ++i) {
            ReportElement retval;
            ReportElement e = band.getElement(i);
            if (id.equals(e.getId())) {
                return e;
            }
            if (!(e instanceof Section) || (retval = FunctionUtilities.findElementById((Section)e, id)) == null) continue;
            return retval;
        }
        return null;
    }

    public static ReportElement findElementByInstanceId(Section band, InstanceID id) {
        if (band == null) {
            throw new NullPointerException("Element name must not be null");
        }
        if (id == null) {
            return null;
        }
        if (band.getObjectID() == id) {
            return band;
        }
        for (int i = 0; i < band.getElementCount(); ++i) {
            ReportElement retval;
            ReportElement e = band.getElement(i);
            if (id == e.getObjectID()) {
                return e;
            }
            if (!(e instanceof Section) || (retval = FunctionUtilities.findElementByInstanceId((Section)e, id)) == null) continue;
            return retval;
        }
        if (band instanceof RootLevelBand) {
            RootLevelBand rootLevelBand = (RootLevelBand)((Object)band);
            SubReport[] reports = rootLevelBand.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport report = reports[i];
                if (report.getObjectID() != id) continue;
                return report;
            }
        }
        return null;
    }

    public static ReportElement findElementByAttribute(Section band, String attributeNamespace, String attributeName, String attributeValue) {
        if (band == null) {
            throw new NullPointerException("Element must not be null");
        }
        if (attributeNamespace == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (attributeName == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attributeValue == null) {
            throw new NullPointerException("Attribute value must not be null");
        }
        if (attributeValue.equals(band.getAttribute(attributeNamespace, attributeName))) {
            return band;
        }
        for (int i = 0; i < band.getElementCount(); ++i) {
            ReportElement retval;
            ReportElement e = band.getElement(i);
            if (attributeValue.equals(e.getAttribute(attributeNamespace, attributeName))) {
                return e;
            }
            if (!(e instanceof Section) || (retval = FunctionUtilities.findElementByAttribute((Section)e, attributeNamespace, attributeName, attributeValue)) == null) continue;
            return retval;
        }
        return null;
    }

    public static Element[] findAllElements(Band band, String element) {
        if (element == null) {
            throw new NullPointerException("Element name must not be null");
        }
        if (band == null) {
            throw new NullPointerException("Band must not be null");
        }
        ArrayList<Band> collector = new ArrayList<Band>();
        if (band.getName().equals(element)) {
            collector.add(band);
        }
        FunctionUtilities.performFindElement(band, element, collector);
        return collector.toArray(new Element[collector.size()]);
    }

    private static void performFindElement(Band band, String element, ArrayList collector) {
        int count = band.getElementCount();
        Element[] buffer = band.getElementArray();
        for (int i = 0; i < count; ++i) {
            Element e = buffer[i];
            if (e.getName().equals(element)) {
                collector.add(e);
            }
            if (!(e instanceof Band)) continue;
            FunctionUtilities.performFindElement((Band)e, element, collector);
        }
    }

    public static boolean isDefinedGroup(String groupName, ReportEvent event) {
        if (groupName == null) {
            return false;
        }
        int groupIndex = event.getState().getCurrentGroupIndex();
        Group group = event.getReport().getGroup(groupIndex);
        return groupName.equals(group.getName());
    }

    public static boolean isDefinedPrepareRunLevel(Function f, ReportEvent event) {
        if (f == null) {
            throw new NullPointerException("Function is null");
        }
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        ReportState state = event.getState();
        if (!state.isPrepareRun()) {
            return false;
        }
        return state.getLevel() == f.getDependencyLevel();
    }

    public static boolean isLayoutLevel(ReportEvent event) {
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        return event.getState().getLevel() == -2;
    }

    public static Group getCurrentGroup(ReportEvent event) {
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        int index = event.getState().getCurrentGroupIndex();
        if (index == -1) {
            throw new IllegalStateException();
        }
        return event.getReport().getGroup(index);
    }

    public static Group getCurrentDeepTraverseGroup(ReportEvent event) {
        if (event == null) {
            throw new NullPointerException("ReportEvent is null");
        }
        if (event.isDeepTraversing()) {
            int index = event.getOriginatingState().getCurrentGroupIndex();
            return event.getOriginatingState().getReport().getGroup(index);
        }
        return FunctionUtilities.getCurrentGroup(event);
    }
}

