/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class GroupCountFunction
extends AbstractFunction {
    private String group;
    private String parentGroup;
    private int count;

    public GroupCountFunction() {
    }

    public GroupCountFunction(String name, String group) {
        this.setName(name);
        this.setGroup(group);
    }

    public String getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(String group) {
        this.parentGroup = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void reportInitialized(ReportEvent event) {
        this.setCount(0);
    }

    public void groupStarted(ReportEvent event) {
        Group group = FunctionUtilities.getCurrentGroup(event);
        if (this.getParentGroup() != null && this.getParentGroup().equals(group.getName())) {
            this.setCount(0);
        }
        if (this.getGroup() == null) {
            this.setCount(this.getCount() + 1);
        } else if (this.getGroup().equals(group.getName())) {
            this.setCount(this.getCount() + 1);
        }
    }

    protected int getCount() {
        return this.count;
    }

    protected void setCount(int count) {
        this.count = count;
    }

    public Object getValue() {
        return new Integer(this.getCount());
    }
}

