/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;

public class HidePageBandForTableExportFunction
extends AbstractFunction
implements LayoutProcessorFunction {
    private boolean hidePageBands = true;
    private boolean disableRepeatingHeader;
    private String exportDescriptor = "table/";

    public void reportInitialized(ReportEvent event) {
        boolean isTable = this.exportDescriptor != null && this.getRuntime().getExportDescriptor().startsWith(this.exportDescriptor);
        ReportDefinition report = event.getReport();
        if (this.isHidePageBands()) {
            report.getPageHeader().setVisible(!isTable);
            report.getPageFooter().setVisible(!isTable);
        }
        if (this.isDisableRepeatingHeader()) {
            int gc = report.getGroupCount();
            for (int i = 0; i < gc; ++i) {
                Group g = report.getGroup(i);
                if (!g.getHeader().isRepeat()) continue;
                g.getHeader().setRepeat(!isTable);
            }
        }
    }

    public String getExportDescriptor() {
        return this.exportDescriptor;
    }

    public void setExportDescriptor(String exportDescriptor) {
        this.exportDescriptor = exportDescriptor;
    }

    public boolean isHidePageBands() {
        return this.hidePageBands;
    }

    public void setHidePageBands(boolean hidePageBands) {
        this.hidePageBands = hidePageBands;
    }

    public boolean isDisableRepeatingHeader() {
        return this.disableRepeatingHeader;
    }

    public void setDisableRepeatingHeader(boolean disableRepeatingHeader) {
        this.disableRepeatingHeader = disableRepeatingHeader;
    }

    public Object getValue() {
        return null;
    }
}

