/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;

public class ItemAvgFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(ItemAvgFunction.class);
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private transient BigDecimal sum = ZERO;
    private transient BigDecimal itemCount = ZERO;
    private String group;
    private String field;
    private int scale = 14;
    private int roundingMode = 4;

    public ItemAvgFunction() {
    }

    public ItemAvgFunction(String name) {
        this();
        this.setName(name);
    }

    public void reportInitialized(ReportEvent event) {
        this.sum = ZERO;
        this.itemCount = ZERO;
    }

    public void groupStarted(ReportEvent event) {
        String mygroup = this.getGroup();
        if (mygroup == null) {
            return;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.sum = ZERO;
            this.itemCount = ZERO;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Number)) {
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.sum = this.sum.add(new BigDecimal(n.toString()));
            this.itemCount = this.itemCount.add(ONE);
        }
        catch (Exception e) {
            logger.error((Object)"ItemAvgFunction.advanceItems(): problem adding number.");
        }
    }

    public Object getValue() {
        if (this.itemCount.longValue() == 0L) {
            return null;
        }
        return this.sum.divide(this.itemCount, this.scale, this.roundingMode);
    }

    public Expression getInstance() {
        ItemAvgFunction function = (ItemAvgFunction)super.getInstance();
        function.sum = ZERO;
        function.itemCount = ZERO;
        return function;
    }
}

