/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class ItemCountFunction
extends AbstractFunction
implements AggregationFunction {
    private transient int count;
    private String group;

    public ItemCountFunction() {
    }

    public ItemCountFunction(String name) {
        this.setName(name);
    }

    protected int getCount() {
        return this.count;
    }

    protected void setCount(int count) {
        this.count = count;
    }

    public void reportInitialized(ReportEvent event) {
        this.setCount(0);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void groupStarted(ReportEvent event) {
        if (this.getGroup() == null) {
            return;
        }
        ReportState state = event.getState();
        Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.setCount(0);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        this.setCount(this.getCount() + 1);
    }

    public Object getValue() {
        return IntegerCache.getInteger(this.getCount());
    }
}

