/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;

public class ItemMaxFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(ItemMaxFunction.class);
    private String group;
    private String field;
    private transient Comparable max = null;

    public ItemMaxFunction() {
    }

    public ItemMaxFunction(String name) {
        this();
        this.setName(name);
    }

    public void reportInitialized(ReportEvent event) {
        this.max = null;
    }

    public void groupStarted(ReportEvent event) {
        String mygroup = this.getGroup();
        if (mygroup == null) {
            return;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.max = null;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            if (this.max == null) {
                this.max = compare;
            } else if (this.max.compareTo(compare) < 0) {
                this.max = compare;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ItemMaxFunction.advanceItems(): problem comparing number.");
        }
    }

    public Object getValue() {
        return this.max;
    }

    public Expression getInstance() {
        ItemMaxFunction function = (ItemMaxFunction)super.getInstance();
        function.max = null;
        return function;
    }
}

