/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;

public class ItemMinFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(ItemMinFunction.class);
    private transient Comparable min = null;
    private String group;
    private String field;

    public ItemMinFunction() {
    }

    public ItemMinFunction(String name) {
        this();
        this.setName(name);
    }

    public void reportInitialized(ReportEvent event) {
        this.min = null;
    }

    public void groupStarted(ReportEvent event) {
        String mygroup = this.getGroup();
        if (mygroup == null) {
            return;
        }
        Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.min = null;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            if (this.min == null) {
                this.min = compare;
            } else if (this.min.compareTo(compare) > 0) {
                this.min = compare;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ItemMinFunction.advanceItems(): problem adding number.");
        }
    }

    public Object getValue() {
        return this.min;
    }

    public Expression getInstance() {
        ItemMinFunction function = (ItemMinFunction)super.getInstance();
        function.min = null;
        return function;
    }
}

