/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.TotalGroupSumFunction;

public class ItemPercentageFunction
extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(ItemPercentageFunction.class);
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private TotalGroupSumFunction totalSumFunction = new TotalGroupSumFunction();
    private transient BigDecimal currentValue;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private String group;
    private String field;
    private int scale;
    private int roundingMode;
    private boolean scaleToHundred;

    public ItemPercentageFunction() {
        this.totalSumFunction.setName("total");
        this.scale = 14;
        this.roundingMode = 4;
        this.scaleToHundred = true;
    }

    public boolean isScaleToHundred() {
        return this.scaleToHundred;
    }

    public void setScaleToHundred(boolean scaleToHundred) {
        this.scaleToHundred = scaleToHundred;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String name) {
        this.group = name;
        this.totalSumFunction.setGroup(this.group);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        this.totalSumFunction.setField(field);
    }

    public void reportStarted(ReportEvent event) {
        this.totalSumFunction.reportStarted(event);
        Object fieldValue = event.getDataRow().get(this.getField());
        if (fieldValue == null) {
            this.currentValue = ZERO;
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.currentValue = new BigDecimal(n.toString());
        }
        catch (Exception e) {
            logger.error((Object)"ItemPercentageFunction.reportStarted(): problem adding number.");
        }
    }

    public void groupStarted(ReportEvent event) {
        this.totalSumFunction.groupStarted(event);
        Object fieldValue = event.getDataRow().get(this.getField());
        if (fieldValue == null) {
            this.currentValue = ZERO;
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.currentValue = new BigDecimal(n.toString());
        }
        catch (Exception e) {
            logger.error((Object)"ItemPercentageFunction.groupStarted(): problem adding number.");
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        this.totalSumFunction.itemsAdvanced(event);
        Object fieldValue = event.getDataRow().get(this.getField());
        if (fieldValue == null) {
            this.currentValue = ZERO;
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.currentValue = new BigDecimal(n.toString());
        }
        catch (Exception e) {
            logger.error((Object)"ItemPercentageFunction.advanceItems(): problem adding number.");
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.totalSumFunction.reportInitialized(event);
        this.currentValue = ZERO;
    }

    public Object getValue() {
        BigDecimal total = (BigDecimal)this.totalSumFunction.getValue();
        if (total == null || total.doubleValue() == 0.0) {
            return null;
        }
        if (this.scaleToHundred) {
            return this.currentValue.multiply(HUNDRED).divide(total, this.scale, this.roundingMode);
        }
        return this.currentValue.divide(total, this.scale, this.roundingMode);
    }

    public Object clone() throws CloneNotSupportedException {
        ItemPercentageFunction clone = (ItemPercentageFunction)super.clone();
        clone.totalSumFunction = (TotalGroupSumFunction)this.totalSumFunction.clone();
        return clone;
    }

    public Expression getInstance() {
        ItemPercentageFunction function = (ItemPercentageFunction)super.getInstance();
        function.totalSumFunction = (TotalGroupSumFunction)this.totalSumFunction.getInstance();
        function.currentValue = ZERO;
        return function;
    }

    public void setDependencyLevel(int level) {
        super.setDependencyLevel(level);
        this.totalSumFunction.setDependencyLevel(level);
    }

    public void setRuntime(ExpressionRuntime runtime) {
        super.setRuntime(runtime);
        this.totalSumFunction.setRuntime(runtime);
    }
}

