/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class ItemSumFunction
extends AbstractFunction
implements FieldAggregationFunction {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    private transient BigDecimal sum = ZERO;
    private String group;
    private String field;

    public ItemSumFunction() {
    }

    public ItemSumFunction(String name) {
        this();
        this.setName(name);
    }

    public void reportInitialized(ReportEvent event) {
        this.sum = ZERO;
    }

    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.sum = ZERO;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = this.getDataRow().get(this.getField());
        if (fieldValue == null) {
            return;
        }
        if (!(fieldValue instanceof Number)) {
            return;
        }
        Number n = (Number)fieldValue;
        this.sum = n instanceof BigDecimal ? this.sum.add((BigDecimal)n) : this.sum.add(new BigDecimal(n.toString()));
    }

    public Object getValue() {
        return this.sum;
    }

    protected BigDecimal getSum() {
        return this.sum;
    }

    protected void setSum(BigDecimal sum) {
        if (sum == null) {
            throw new NullPointerException("Sum must not be null");
        }
        this.sum = sum;
    }

    public Expression getInstance() {
        ItemSumFunction function = (ItemSumFunction)super.getInstance();
        function.sum = ZERO;
        return function;
    }
}

