/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class NegativeNumberPaintChangeFunction
extends AbstractElementFormatFunction {
    private String field;
    private Color positiveColor;
    private Color negativeColor;
    private Color zeroColor;

    protected void processRootBand(Band b) {
        Element[] elements = FunctionUtilities.findAllElements(b, this.getElement());
        if (elements.length == 0) {
            return;
        }
        Color color = this.computeColor();
        for (int i = 0; i < elements.length; ++i) {
            elements[i].getStyle().setStyleProperty(ElementStyleKeys.PAINT, color);
        }
    }

    protected Color computeColor() {
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Number)) {
            return this.getPositiveColor();
        }
        Number n = (Number)o;
        double d = n.doubleValue();
        if (d < 0.0) {
            return this.getNegativeColor();
        }
        if (d > 0.0) {
            return this.getPositiveColor();
        }
        Color zeroColor = this.getZeroColor();
        if (zeroColor == null) {
            return this.getPositiveColor();
        }
        return zeroColor;
    }

    public Color getPositiveColor() {
        return this.positiveColor;
    }

    public void setPositiveColor(Color positiveColor) {
        this.positiveColor = positiveColor;
    }

    public Color getNegativeColor() {
        return this.negativeColor;
    }

    public void setNegativeColor(Color negativeColor) {
        this.negativeColor = negativeColor;
    }

    public Color getZeroColor() {
        return this.zeroColor;
    }

    public void setZeroColor(Color zeroColor) {
        this.zeroColor = zeroColor;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }
}

