/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class PaintComponentFunction
extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(PaintComponentFunction.class);
    private transient Frame peerSupply;
    private String element;
    private String field;
    private float scale;

    public PaintComponentFunction() {
        if (!PaintComponentFunction.isHeadless()) {
            this.peerSupply = new Frame();
            this.peerSupply.setLayout(new BorderLayout());
        }
        this.scale = 1.0f;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.element = field;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    protected static boolean isHeadless() {
        return "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("java.awt.headless", "false"));
    }

    public Object getValue() {
        return null;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public Expression getInstance() {
        PaintComponentFunction pc = (PaintComponentFunction)super.getInstance();
        if (!PaintComponentFunction.isHeadless()) {
            pc.peerSupply = new Frame();
            pc.peerSupply.setLayout(new BorderLayout());
        }
        return pc;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!PaintComponentFunction.isHeadless()) {
            this.peerSupply = new Frame();
            this.peerSupply.setLayout(new BorderLayout());
        }
    }
}

