/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;

public class PercentageExpression
extends AbstractExpression {
    private static final BigDecimal ZERO = new BigDecimal(0);
    private String dividend;
    private String divisor;
    private boolean useDifference;
    private int scale = 14;
    private int roundingMode = 4;

    public boolean isUseDifference() {
        return this.useDifference;
    }

    public void setUseDifference(boolean useDifference) {
        this.useDifference = useDifference;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDividend() {
        return this.dividend;
    }

    public String getDivisor() {
        return this.divisor;
    }

    public void setDividend(String dividend) {
        this.dividend = dividend;
    }

    public void setDivisor(String divisor) {
        this.divisor = divisor;
    }

    public Object getValue() {
        BigDecimal divisor;
        BigDecimal dividend;
        if (this.dividend == null || this.divisor == null) {
            return null;
        }
        Object dividentFieldValue = this.getDataRow().get(this.getDividend());
        if (dividentFieldValue instanceof BigDecimal) {
            dividend = (BigDecimal)dividentFieldValue;
        } else {
            if (!(dividentFieldValue instanceof Number)) {
                return null;
            }
            dividend = new BigDecimal(dividentFieldValue.toString());
        }
        Object divisorFieldValue = this.getDataRow().get(this.getDivisor());
        if (divisorFieldValue instanceof BigDecimal) {
            divisor = (BigDecimal)divisorFieldValue;
        } else {
            if (!(divisorFieldValue instanceof Number)) {
                return null;
            }
            divisor = new BigDecimal(divisorFieldValue.toString());
        }
        if (ZERO.compareTo(divisor) == 0) {
            return null;
        }
        if (this.useDifference) {
            BigDecimal delta = dividend.subtract(divisor);
            return delta.divide(divisor, this.scale, this.roundingMode);
        }
        return dividend.divide(divisor, this.scale, this.roundingMode);
    }
}

