/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.ContextEvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.typing.DefaultTypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class ReportFormulaContext
implements FormulaContext {
    private FormulaContext backend;
    private ProcessingContext processingContext;
    private ExpressionRuntime runtime;
    private DefaultTypeRegistry typeRegistry;

    public ReportFormulaContext(FormulaContext backend, ExpressionRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException("Runtime is null.");
        }
        if (backend == null) {
            throw new NullPointerException("Backend-FormulaContext is null");
        }
        this.runtime = runtime;
        this.backend = backend;
        this.typeRegistry = new DefaultTypeRegistry();
        this.typeRegistry.initialize((FormulaContext)this);
        this.processingContext = runtime.getProcessingContext();
    }

    public DataSchema getDataSchema() {
        return this.runtime.getDataSchema();
    }

    public LocalizationContext getLocalizationContext() {
        return this.backend.getLocalizationContext();
    }

    public Configuration getConfiguration() {
        return this.backend.getConfiguration();
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.backend.getFunctionRegistry();
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public OperatorFactory getOperatorFactory() {
        return this.backend.getOperatorFactory();
    }

    public boolean isReferenceDirty(Object name) throws ContextEvaluationException {
        return this.runtime.getDataRow().isChanged((String)name);
    }

    public Type resolveReferenceType(Object name) {
        return AnyType.TYPE;
    }

    public Object resolveReference(Object name) throws ContextEvaluationException {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.runtime.getDataRow().get(String.valueOf(name));
    }

    public DataRow getDataRow() {
        return this.runtime.getDataRow();
    }

    public void close() {
        this.runtime = null;
        this.processingContext = null;
    }

    public String getExportType() {
        return this.processingContext.getExportDescriptor();
    }

    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public boolean isResultSetEmpty() {
        TableModel data = this.runtime.getData();
        return data == null || data.getRowCount() == 0 || data.getColumnCount() == 0;
    }

    public ExpressionRuntime getRuntime() {
        return this.runtime;
    }
}

