/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class RowBandingFunction
extends AbstractFunction
implements PageEventListener,
LayoutProcessorFunction {
    private static final Log logger = LogFactory.getLog(RowBandingFunction.class);
    private transient boolean trigger;
    private transient int count;
    private transient boolean warned = false;
    private Boolean newPageState;
    private int numberOfElements = 1;
    private String element;
    private boolean initialState;
    private Color visibleBackground;
    private Color invisibleBackground;

    public void pageStarted(ReportEvent event) {
        if (this.newPageState != null) {
            this.trigger = this.newPageState == false;
            this.count = 0;
            this.triggerVisibleState(event);
        }
    }

    public void pageFinished(ReportEvent event) {
    }

    public void reportInitialized(ReportEvent event) {
        this.trigger = !this.getInitialState();
        this.count = 0;
    }

    public void itemsStarted(ReportEvent event) {
        this.trigger = !this.getInitialState();
        this.count = 0;
    }

    public void itemsAdvanced(ReportEvent event) {
        this.triggerVisibleState(event);
    }

    private void triggerVisibleState(ReportEvent event) {
        if (this.count % this.numberOfElements == 0) {
            this.trigger = !this.trigger;
        }
        ++this.count;
        ItemBand itemBand = event.getReport().getItemBand();
        if (this.element == null) {
            if (this.trigger) {
                itemBand.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.visibleBackground);
            } else {
                itemBand.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.invisibleBackground);
            }
        } else {
            Element[] e = FunctionUtilities.findAllElements(itemBand, this.getElement());
            if (e.length > 0) {
                for (int i = 0; i < e.length; ++i) {
                    if (this.trigger) {
                        e[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.visibleBackground);
                        continue;
                    }
                    e[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.invisibleBackground);
                }
            } else if (!this.warned) {
                logger.warn((Object)("The Band does not contain an element named " + this.getElement()));
                this.warned = true;
            }
        }
    }

    public Color getInvisibleBackground() {
        return this.invisibleBackground;
    }

    public void setInvisibleBackground(Color invisibleBackground) {
        this.invisibleBackground = invisibleBackground;
    }

    public Color getVisibleBackground() {
        return this.visibleBackground;
    }

    public void setVisibleBackground(Color visibleBackground) {
        this.visibleBackground = visibleBackground;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public boolean getInitialTriggerValue() {
        return this.initialState;
    }

    public boolean getInitialState() {
        return this.initialState;
    }

    public void setInitialState(boolean initialState) {
        this.initialState = initialState;
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getElement() {
        return this.element;
    }

    public Boolean getNewPageState() {
        return this.newPageState;
    }

    public void setNewPageState(Boolean newPageState) {
        this.newPageState = newPageState;
    }

    public Object getValue() {
        if (this.trigger) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

