/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class ShowElementIfDataAvailableExpression
extends AbstractElementFormatFunction {
    protected void processRootBand(Band b) {
        boolean visible = this.isDataAvailable();
        Element[] elements = FunctionUtilities.findAllElements(b, this.getElement());
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            element.setVisible(visible);
        }
    }

    private boolean isDataAvailable() {
        ExpressionRuntime runtime = this.getRuntime();
        if (runtime == null) {
            return false;
        }
        TableModel data = runtime.getData();
        if (data == null) {
            return false;
        }
        return data.getRowCount() != 0;
    }

    public Object getValue() {
        if (this.isDataAvailable()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

