/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class TotalCalculationFunction
extends AbstractFunction {
    private transient HashMap results = new HashMap();
    private String field;
    private String group;
    private transient Object result;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;

    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            this.result = this.getDataRow().get(this.getField());
            this.results.put(this.globalStateKey, this.result);
        } else {
            this.result = this.results.get(this.globalStateKey);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        this.groupStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = this.getDataRow().get(this.getField());
            this.results.put(this.globalStateKey, this.result);
            this.results.put(this.groupStateKey, this.result);
        } else {
            this.result = this.results.get(this.groupStateKey);
        }
    }

    public void groupFinished(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = this.getDataRow().get(this.getField());
            this.results.put(this.globalStateKey, this.result);
            if (this.groupStateKey != null) {
                this.results.put(this.groupStateKey, this.result);
            }
        }
    }

    public void reportFinished(ReportEvent event) {
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = this.getDataRow().get(this.getField());
            this.results.put(this.globalStateKey, this.result);
            if (this.groupStateKey != null) {
                this.results.put(this.groupStateKey, this.result);
            }
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getValue() {
        return this.result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }

    public Expression getInstance() {
        TotalCalculationFunction fn = (TotalCalculationFunction)super.getInstance();
        fn.results = new HashMap();
        return fn;
    }
}

