/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.GroupCountFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class TotalGroupCountFunction
extends GroupCountFunction {
    private transient HashMap results = new HashMap();
    private transient Integer result;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;

    public void reportInitialized(ReportEvent event) {
        super.reportInitialized(event);
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            this.result = IntegerCache.getInteger(this.getCount());
            this.results.put(this.globalStateKey, this.result);
        } else {
            this.result = (Integer)this.results.get(this.globalStateKey);
        }
    }

    public void groupStarted(ReportEvent event) {
        String definedGroupName;
        super.groupStarted(event);
        Group group = FunctionUtilities.getCurrentGroup(event);
        if (group.getName().equals(this.getParentGroup())) {
            this.groupStateKey = event.getState().getProcessKey();
            if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
                this.result = IntegerCache.getInteger(this.getCount());
                this.results.put(this.globalStateKey, this.result);
                this.results.put(this.groupStateKey, this.result);
                return;
            }
            this.result = (Integer)this.results.get(this.groupStateKey);
        }
        if (((definedGroupName = this.getGroup()) == null || group.getName().equals(definedGroupName)) && FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = IntegerCache.getInteger(this.getCount());
            this.results.put(this.globalStateKey, this.result);
            this.results.put(this.groupStateKey, this.result);
        }
    }

    public Object getValue() {
        return this.result;
    }

    public Expression getInstance() {
        TotalGroupCountFunction fn = (TotalGroupCountFunction)super.getInstance();
        fn.results = new HashMap();
        return fn;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }
}

