/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class TotalGroupSumFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private transient HashMap results = new HashMap();
    private String field;
    private String group;
    private transient BigDecimal result;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;

    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            this.result = new BigDecimal(0);
            this.results.put(this.globalStateKey, this.result);
        } else {
            this.result = (BigDecimal)this.results.get(this.globalStateKey);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        this.groupStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = new BigDecimal(0);
            this.results.put(this.globalStateKey, this.result);
            this.results.put(this.groupStateKey, this.result);
        } else {
            this.result = (BigDecimal)this.results.get(this.groupStateKey);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        BigDecimal value;
        if (this.field == null) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        Object fieldValue = event.getDataRow().get(this.getField());
        if (fieldValue instanceof BigDecimal) {
            value = (BigDecimal)fieldValue;
        } else if (fieldValue instanceof Integer || fieldValue instanceof Long || fieldValue instanceof Short || fieldValue instanceof Byte) {
            Number n = (Number)fieldValue;
            value = new BigDecimal(n.longValue());
        } else if (fieldValue instanceof Number) {
            value = new BigDecimal(String.valueOf(fieldValue));
        } else {
            return;
        }
        this.result = this.result.add(value);
        this.results.put(this.globalStateKey, this.result);
        if (this.groupStateKey != null) {
            this.results.put(this.groupStateKey, this.result);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Object getValue() {
        return this.result;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Expression getInstance() {
        TotalGroupSumFunction function = (TotalGroupSumFunction)super.getInstance();
        function.result = null;
        function.results = new HashMap();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
        this.result = null;
    }
}

