/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class TotalItemCountFunction
extends AbstractFunction
implements AggregationFunction {
    private transient HashMap results = new HashMap();
    private String group;
    private transient Integer result;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;

    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (this.isPrepareRunLevel(event)) {
            this.results.clear();
            this.result = IntegerCache.getInteger(0);
            this.results.put(this.globalStateKey, this.result);
        } else {
            this.result = (Integer)this.results.get(this.globalStateKey);
        }
    }

    protected boolean isPrepareRunLevel(ReportEvent event) {
        return FunctionUtilities.isDefinedPrepareRunLevel(this, event);
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        this.groupStateKey = event.getState().getProcessKey();
        if (this.isPrepareRunLevel(event)) {
            this.result = IntegerCache.getInteger(0);
            this.results.put(this.globalStateKey, this.result);
            this.results.put(this.groupStateKey, this.result);
        } else {
            this.result = (Integer)this.results.get(this.groupStateKey);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (!this.isPrepareRunLevel(event)) {
            return;
        }
        this.result = IntegerCache.getInteger(this.result + 1);
        this.results.put(this.globalStateKey, this.result);
        if (this.groupStateKey != null) {
            this.results.put(this.groupStateKey, this.result);
        }
    }

    protected Integer getCount() {
        return this.result;
    }

    protected void setCount(Integer result) {
        if (result == null) {
            throw new NullPointerException();
        }
        this.result = result;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Object getValue() {
        return this.result;
    }

    public Expression getInstance() {
        TotalItemCountFunction function = (TotalItemCountFunction)super.getInstance();
        function.results = new HashMap();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }
}

