/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class TotalItemMinFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(TotalItemMinFunction.class);
    private transient HashMap results = new HashMap();
    private String group;
    private String field;
    private transient Comparable min;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            this.min = null;
            this.results.put(this.globalStateKey, null);
        } else {
            this.min = (Comparable)this.results.get(this.globalStateKey);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        this.groupStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.min = null;
            this.results.put(this.globalStateKey, this.min);
            this.results.put(this.groupStateKey, this.min);
        } else {
            this.min = (Comparable)this.results.get(this.groupStateKey);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Comparable)) {
            return;
        }
        try {
            Comparable compare = (Comparable)fieldValue;
            if (this.min == null) {
                this.min = compare;
            } else if (this.min.compareTo(compare) > 0) {
                this.min = compare;
            }
        }
        catch (Exception e) {
            logger.error((Object)"TotalItemMinFunction.advanceItems(): problem comparing values.");
        }
        this.results.put(this.globalStateKey, this.min);
        if (this.groupStateKey != null) {
            this.results.put(this.groupStateKey, this.min);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Object getValue() {
        return this.min;
    }

    public Expression getInstance() {
        TotalItemMinFunction function = (TotalItemMinFunction)super.getInstance();
        function.results = new HashMap();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }
}

