/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.layout.LayoutSupport;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class WrapperExpressionRuntime
implements ExpressionRuntime {
    private DataRow dataRow;
    private ExpressionRuntime runtime;
    private WrapperProcessingContext processingContext;

    public WrapperExpressionRuntime() {
    }

    public WrapperExpressionRuntime(DataRow overrideValues, ExpressionRuntime runtime) {
        this.update(overrideValues, runtime);
    }

    public void update(DataRow overrideValues, ExpressionRuntime runtime) {
        if (runtime == null) {
            this.dataRow = null;
            this.runtime = null;
            this.processingContext = null;
            return;
        }
        this.dataRow = overrideValues != null ? new CompoundDataRow(overrideValues, runtime.getDataRow()) : runtime.getDataRow();
        this.processingContext = new WrapperProcessingContext(runtime);
        this.runtime = runtime;
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public DataSchema getDataSchema() {
        return this.runtime.getDataSchema();
    }

    public Configuration getConfiguration() {
        return this.runtime.getConfiguration();
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.runtime.getResourceBundleFactory();
    }

    public TableModel getData() {
        return this.runtime.getData();
    }

    public int getCurrentRow() {
        return this.runtime.getCurrentRow();
    }

    public int getCurrentGroup() {
        return this.runtime.getCurrentGroup();
    }

    public int getGroupStartRow(String groupName) {
        return this.runtime.getGroupStartRow(groupName);
    }

    public int getGroupStartRow(int groupIndex) {
        return this.runtime.getGroupStartRow(groupIndex);
    }

    public String getExportDescriptor() {
        return this.runtime.getExportDescriptor();
    }

    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public DataFactory getDataFactory() {
        return this.runtime.getDataFactory();
    }

    private static class WrapperProcessingContext
    implements ProcessingContext {
        private ProcessingContext context;
        private ExpressionRuntime runtime;

        private WrapperProcessingContext(ExpressionRuntime runtime) {
            this.context = runtime.getProcessingContext();
            this.runtime = runtime;
        }

        public int getProgressLevel() {
            return this.context.getProgressLevel();
        }

        public int getProgressLevelCount() {
            return this.context.getProgressLevelCount();
        }

        public int getProcessingLevel() {
            return this.context.getProcessingLevel();
        }

        public FormulaContext getFormulaContext() {
            return new ReportFormulaContext(this.context.getFormulaContext(), this.runtime);
        }

        public boolean isPrepareRun() {
            return this.context.isPrepareRun();
        }

        public String getExportDescriptor() {
            return this.context.getExportDescriptor();
        }

        public OutputProcessorMetaData getOutputProcessorMetaData() {
            return this.context.getOutputProcessorMetaData();
        }

        public LayoutSupport getLayoutSupport() {
            return this.context.getLayoutSupport();
        }

        public ResourceBundleFactory getResourceBundleFactory() {
            return this.context.getResourceBundleFactory();
        }

        public ResourceKey getContentBase() {
            return this.context.getContentBase();
        }

        public ResourceManager getResourceManager() {
            return this.context.getResourceManager();
        }

        public Configuration getConfiguration() {
            return this.context.getConfiguration();
        }

        public DocumentMetaData getDocumentMetaData() {
            return this.context.getDocumentMetaData();
        }

        public ReportEnvironment getEnvironment() {
            return this.context.getEnvironment();
        }

        public int getCompatibilityLevel() {
            return this.context.getCompatibilityLevel();
        }
    }
}

