/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.date;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;

public class DateExpression
extends AbstractExpression {
    private Integer month;
    private Integer year;
    private Integer hour;
    private Integer minute;
    private Integer second;
    private Integer milliSecond;
    private Long time;
    private Long epochTime;
    private Integer dayOfWeek;
    private Integer dayOfYear;
    private Integer dayOfMonth;
    private Integer dayOfWeekInMonth;
    private TimeZone timeZone;
    private Integer weekOfYear;
    private Integer weekOfMonth;

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getDay() {
        return this.dayOfMonth;
    }

    public void setDay(Integer day) {
        this.dayOfMonth = day;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getHour() {
        return this.hour;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public void setSecond(Integer second) {
        this.second = second;
    }

    public Integer getMilliSecond() {
        return this.milliSecond;
    }

    public void setMilliSecond(Integer milliSecond) {
        this.milliSecond = milliSecond;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Long getEpochTime() {
        return this.epochTime;
    }

    public void setEpochTime(Long epochTime) {
        this.epochTime = epochTime;
    }

    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public Integer getDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(Integer dayOfYear) {
        this.dayOfYear = dayOfYear;
    }

    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public Integer getDayOfWeekInMonth() {
        return this.dayOfWeekInMonth;
    }

    public void setDayOfWeekInMonth(Integer dayOfWeekInMonth) {
        this.dayOfWeekInMonth = dayOfWeekInMonth;
    }

    public Integer getWeekOfYear() {
        return this.weekOfYear;
    }

    public void setWeekOfYear(Integer weekOfYear) {
        this.weekOfYear = weekOfYear;
    }

    public Integer getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public void setWeekOfMonth(Integer weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
    }

    public Object getValue() {
        Calendar calendar = this.getCalendar();
        this.configureCalendar(calendar);
        return calendar.getTime();
    }

    protected void configureCalendar(Calendar calendar) {
        if (this.time != null) {
            calendar.setTime(new Date(this.time));
        }
        if (this.epochTime != null) {
            calendar.setTime(new Date(this.epochTime * 1000L));
        }
        if (this.month != null) {
            calendar.set(2, this.month);
        }
        if (this.dayOfMonth != null) {
            calendar.set(5, this.dayOfMonth);
        }
        if (this.year != null) {
            calendar.set(1, this.year);
        }
        if (this.hour != null) {
            calendar.set(11, this.hour);
        }
        if (this.minute != null) {
            calendar.set(12, this.minute);
        }
        if (this.second != null) {
            calendar.set(13, this.second);
        }
        if (this.milliSecond != null) {
            calendar.set(14, this.milliSecond);
        }
        if (this.dayOfWeek != null) {
            calendar.set(7, this.dayOfWeek);
        }
        if (this.dayOfYear != null) {
            calendar.set(6, this.dayOfYear);
        }
        if (this.dayOfWeekInMonth != null) {
            calendar.set(8, this.dayOfWeekInMonth);
        }
        if (this.weekOfYear != null) {
            calendar.set(3, this.weekOfYear);
        }
        if (this.weekOfMonth != null) {
            calendar.set(4, this.weekOfMonth);
        }
        if (this.timeZone != null) {
            calendar.setTimeZone(this.getTimeZone());
        }
    }

    protected Calendar getCalendar() {
        ResourceBundleFactory rf = this.getResourceBundleFactory();
        return Calendar.getInstance(rf.getLocale());
    }
}

