/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import java.text.NumberFormat;
import java.util.Locale;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class EngineeringNotationFunction
implements Function {
    private static final String[] SUFFIXES = new String[]{"y", "z", "a", "f", "p", "n", "\u00b5", "m", " ", "k", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final int OFFSET = 8;

    public String getCanonicalName() {
        return "ENGINEERINGNOTATION";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int log10;
        int index;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        double value = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0)).doubleValue();
        boolean fixedSize = false;
        int precision = 0;
        if (value == 0.0) {
            return new TypeValuePair((Type)TextType.TYPE, (Object)"0");
        }
        if (parameters.getParameterCount() > 1) {
            fixedSize = true;
            precision = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1)).intValue();
            if (parameters.getParameterCount() == 3) {
                Boolean rawFixedSize = typeRegistry.convertToLogical(parameters.getType(2), parameters.getValue(2));
                fixedSize = rawFixedSize;
            }
        }
        if ((index = (int)(Math.floor((double)(log10 = this.computeLog10(value)) / 3.0) + 8.0)) < 0 || index >= SUFFIXES.length) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        int roundPrecision = fixedSize ? log10 - precision : log10 - (precision + (3 + log10 % 3) % 3);
        double roundingScale = Math.pow(10.0, roundPrecision);
        double rounded = (double)Math.round(value / roundingScale) * roundingScale;
        double outputValue = rounded / Math.pow(10.0, Math.floor((double)log10 / 3.0) * 3.0);
        int outputValueDecimalPlaces = Math.max(1, this.computeLog10(outputValue));
        Locale locale = context.getLocalizationContext().getLocale();
        NumberFormat decimalFormat = this.createDecimalFormat(fixedSize, outputValueDecimalPlaces, precision, locale);
        String result = decimalFormat.format(outputValue) + SUFFIXES[index];
        return new TypeValuePair((Type)TextType.TYPE, (Object)result);
    }

    private NumberFormat createDecimalFormat(boolean fixedSize, int decimalPlaces, int precision, Locale locale) {
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        format.setGroupingUsed(false);
        if (fixedSize) {
            format.setMinimumFractionDigits(Math.max(0, precision - decimalPlaces - 1));
        } else {
            format.setMinimumFractionDigits(precision);
        }
        return format;
    }

    private int computeLog10(double value) {
        boolean inverted;
        double analysis = Math.abs(value);
        if (analysis < 1.0) {
            analysis = 1.0 / analysis;
            inverted = true;
        } else {
            inverted = false;
        }
        int log = 0;
        while (analysis >= 10.0) {
            ++log;
            analysis /= 10.0;
        }
        return inverted ? -log - 1 : log;
    }
}

