/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class MultiValueQueryFunction
implements Function {
    private static final Log logger = LogFactory.getLog(MultiValueQueryFunction.class);

    public String getCanonicalName() {
        return "MULTIVALUEQUERY";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int queryLimit;
        int queryTimeOut;
        String resultColumn;
        if (!(context instanceof ReportFormulaContext)) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_FUNCTION_VALUE);
        }
        ReportFormulaContext rfc = (ReportFormulaContext)context;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String query = context.getTypeRegistry().convertToText(textType, textValue);
        if (query == null) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (parameterCount > 1) {
            Type encodingType = parameters.getType(1);
            Object encodingValue = parameters.getValue(1);
            resultColumn = context.getTypeRegistry().convertToText(encodingType, encodingValue);
            if (resultColumn == null) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        } else {
            resultColumn = null;
        }
        if (parameterCount > 2) {
            Type encodingType = parameters.getType(2);
            Object encodingValue = parameters.getValue(2);
            Number number = context.getTypeRegistry().convertToNumber(encodingType, encodingValue);
            if (number == null) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            queryTimeOut = number.intValue();
        } else {
            queryTimeOut = 0;
        }
        if (parameterCount > 3) {
            Type encodingType = parameters.getType(3);
            Object encodingValue = parameters.getValue(3);
            Number number = context.getTypeRegistry().convertToNumber(encodingType, encodingValue);
            if (number == null) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            queryLimit = number.intValue();
        } else {
            queryLimit = 0;
        }
        Object result = this.performQuery(rfc, query, resultColumn, queryTimeOut, queryLimit);
        return new TypeValuePair((Type)AnyType.ANY_ARRAY, result);
    }

    private Object performQuery(ReportFormulaContext context, String query, String columnName, int queryTimeout, int queryLimit) {
        try {
            DataFactory dataFactory = context.getRuntime().getDataFactory();
            TableModel tableModel = dataFactory.queryData(query, new QueryDataRowWrapper(context.getDataRow(), queryLimit, queryTimeout));
            if (tableModel == null) {
                return null;
            }
            int columnCount = tableModel.getColumnCount();
            if (tableModel.getRowCount() == 0 || columnCount == 0) {
                return null;
            }
            for (int column = 0; column < columnCount; ++column) {
                if (columnName != null && !columnName.equals(tableModel.getColumnName(column))) continue;
                ArrayList<Object> values = new ArrayList<Object>();
                int rowCount = tableModel.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    values.add(tableModel.getValueAt(row, column));
                }
                return values.toArray();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"SingleValueQueryFunction: Failed to perform query", (Throwable)e);
        }
        return null;
    }
}

