/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;
import org.pentaho.reporting.libraries.xmlns.writer.HtmlCharacterEntities;

public class QuoteTextFunction
implements Function {
    public String getCanonicalName() {
        return "QUOTETEXT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        String encodingResult;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String textResult = context.getTypeRegistry().convertToText(textType, textValue);
        if (textResult == null) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (parameterCount == 2) {
            Type encodingType = parameters.getType(1);
            Object encodingValue = parameters.getValue(1);
            encodingResult = context.getTypeRegistry().convertToText(encodingType, encodingValue);
            if (encodingResult == null) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        } else {
            encodingResult = "javascript";
        }
        if (encodingResult.equals("xml")) {
            return new TypeValuePair((Type)TextType.TYPE, (Object)CharacterEntityParser.createXMLEntityParser().encodeEntities(textResult));
        }
        if (encodingResult.equals("html")) {
            return new TypeValuePair((Type)TextType.TYPE, (Object)HtmlCharacterEntities.getEntityParser().encodeEntities(textResult));
        }
        if (encodingResult.equals("formula-string")) {
            return new TypeValuePair((Type)TextType.TYPE, (Object)FormulaUtil.quoteString((String)textResult));
        }
        if (encodingResult.equals("formula-reference")) {
            return new TypeValuePair((Type)TextType.TYPE, (Object)FormulaUtil.quoteReference((String)textResult));
        }
        return new TypeValuePair((Type)TextType.TYPE, (Object)QuoteTextFunction.saveConvert(textResult));
    }

    public static String saveConvert(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        char[] string = text.toCharArray();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        block9: for (int x = 0; x < string.length; ++x) {
            char aChar = string[x];
            switch (aChar) {
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block9;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block9;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block9;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block9;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block9;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block9;
                }
                case '\"': 
                case '&': 
                case '\'': {
                    buffer.append('\\');
                    buffer.append(aChar);
                    continue block9;
                }
                default: {
                    buffer.append(aChar);
                }
            }
        }
        return buffer.toString();
    }
}

