/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.strings;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class MapIndirectExpression
extends AbstractExpression {
    private String field;
    private ArrayList keys = new ArrayList();
    private ArrayList forwards = new ArrayList();
    private boolean ignoreCase;
    private String fallbackForward;
    private String nullValue;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getFallbackForward() {
        return this.fallbackForward;
    }

    public void setFallbackForward(String fallbackForward) {
        this.fallbackForward = fallbackForward;
    }

    public void setKey(int index, String key) {
        if (this.keys.size() == index) {
            this.keys.add(key);
        } else {
            this.keys.set(index, key);
        }
    }

    public String getKey(int index) {
        return (String)this.keys.get(index);
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public String[] getKey() {
        return this.keys.toArray(new String[this.keys.size()]);
    }

    public void setKey(String[] keys) {
        this.keys.clear();
        this.keys.addAll(Arrays.asList(keys));
    }

    public void setForward(int index, String value) {
        if (this.forwards.size() == index) {
            this.forwards.add(value);
        } else {
            this.forwards.set(index, value);
        }
    }

    public String getForward(int index) {
        return (String)this.forwards.get(index);
    }

    public int getForwardCount() {
        return this.forwards.size();
    }

    public String[] getForward() {
        return this.forwards.toArray(new String[this.forwards.size()]);
    }

    public void setForward(String[] forwards) {
        this.forwards.clear();
        this.forwards.addAll(Arrays.asList(forwards));
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Expression getInstance() {
        MapIndirectExpression co = (MapIndirectExpression)super.getInstance();
        co.forwards = (ArrayList)this.forwards.clone();
        co.keys = (ArrayList)this.keys.clone();
        return co;
    }

    public Object getValue() {
        Object raw = this.getDataRow().get(this.getField());
        if (raw == null) {
            return this.getNullValue();
        }
        String text = String.valueOf(raw);
        int length = Math.min(this.keys.size(), this.forwards.size());
        for (int i = 0; i < length; ++i) {
            String key = (String)this.keys.get(i);
            if (this.isIgnoreCase()) {
                if (!text.equalsIgnoreCase(key)) continue;
                String target = (String)this.forwards.get(i);
                return this.getDataRow().get(target);
            }
            if (!text.equals(key)) continue;
            String target = (String)this.forwards.get(i);
            return this.getDataRow().get(target);
        }
        String fallbackValue = this.getFallbackForward();
        if (fallbackValue != null) {
            return this.getDataRow().get(fallbackValue);
        }
        return raw;
    }
}

