/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.strings;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class MapStringExpression
extends AbstractExpression {
    private String field;
    private ArrayList keys = new ArrayList();
    private ArrayList values = new ArrayList();
    private boolean ignoreCase;
    private String fallbackValue;
    private String nullValue;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getFallbackValue() {
        return this.fallbackValue;
    }

    public void setFallbackValue(String fallbackValue) {
        this.fallbackValue = fallbackValue;
    }

    public void setKey(int index, String key) {
        if (this.keys.size() == index) {
            this.keys.add(key);
        } else {
            this.keys.set(index, key);
        }
    }

    public String getKey(int index) {
        return (String)this.keys.get(index);
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public String[] getKey() {
        return this.keys.toArray(new String[this.keys.size()]);
    }

    public void setKey(String[] keys) {
        this.keys.clear();
        this.keys.addAll(Arrays.asList(keys));
    }

    public void setText(int index, String value) {
        if (this.values.size() == index) {
            this.values.add(value);
        } else {
            this.values.set(index, value);
        }
    }

    public String getText(int index) {
        return (String)this.values.get(index);
    }

    public int getTextCount() {
        return this.values.size();
    }

    public String[] getText() {
        return this.values.toArray(new String[this.values.size()]);
    }

    public void setText(String[] texts) {
        this.values.clear();
        this.values.addAll(Arrays.asList(texts));
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Expression getInstance() {
        MapStringExpression co = (MapStringExpression)super.getInstance();
        co.values = (ArrayList)this.values.clone();
        co.keys = (ArrayList)this.keys.clone();
        return co;
    }

    public Object getValue() {
        Object raw = this.getDataRow().get(this.getField());
        if (raw == null) {
            return this.getNullValue();
        }
        String text = String.valueOf(raw);
        int length = Math.min(this.keys.size(), this.values.size());
        for (int i = 0; i < length; ++i) {
            String key = (String)this.keys.get(i);
            if (!(this.isIgnoreCase() ? text.equalsIgnoreCase(key) : text.equals(key))) continue;
            return this.values.get(i);
        }
        String fallbackValue = this.getFallbackValue();
        if (fallbackValue != null) {
            return fallbackValue;
        }
        return raw;
    }
}

