/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.strings;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

public class MessageFormatExpression
extends AbstractExpression {
    private static final Log logger = LogFactory.getLog(MessageFormatExpression.class);
    private String pattern;
    private MessageFormatSupport messageFormatSupport = new MessageFormatSupport();
    private boolean urlEncodeData;
    private boolean urlEncodeResult;
    private String encoding = "ISO-8859-1";

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.encoding = encoding;
    }

    public void setUrlEncodeValues(boolean urlEncode) {
        this.urlEncodeData = urlEncode;
    }

    public boolean isUrlEncodeValues() {
        return this.urlEncodeData;
    }

    public boolean isUrlEncodeResult() {
        return this.urlEncodeResult;
    }

    public void setUrlEncodeResult(boolean urlEncodeResult) {
        this.urlEncodeResult = urlEncodeResult;
    }

    public String getNullString() {
        return this.messageFormatSupport.getNullString();
    }

    public void setNullString(String nullString) {
        this.messageFormatSupport.setNullString(nullString);
    }

    public Object getValue() {
        String result;
        ResourceBundleFactory resourceBundleFactory = this.getResourceBundleFactory();
        this.messageFormatSupport.setFormatString(this.pattern);
        this.messageFormatSupport.setLocale(resourceBundleFactory.getLocale());
        if (this.isUrlEncodeValues()) {
            EncodeDataRow dataRow = new EncodeDataRow();
            dataRow.setEncoding(this.encoding);
            dataRow.setWrappedDataRow(this.getDataRow());
            result = this.messageFormatSupport.performFormat(dataRow);
        } else {
            result = this.messageFormatSupport.performFormat(this.getDataRow());
        }
        if (this.isUrlEncodeResult()) {
            try {
                return URLEncoder.encode((String)result, (String)this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                logger.debug((Object)("Unsupported Encoding: " + this.encoding));
                return null;
            }
        }
        return result;
    }

    public Expression getInstance() {
        MessageFormatExpression ex = (MessageFormatExpression)super.getInstance();
        ex.messageFormatSupport = new MessageFormatSupport();
        return ex;
    }

    private static class EncodeDataRow
    implements DataRow {
        private DataRow wrappedDataRow;
        private String encoding;

        protected EncodeDataRow() {
        }

        public DataRow getWrappedDataRow() {
            return this.wrappedDataRow;
        }

        public void setWrappedDataRow(DataRow wrappedDataRow) {
            this.wrappedDataRow = wrappedDataRow;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            if (encoding == null) {
                throw new NullPointerException();
            }
            this.encoding = encoding;
        }

        private Object encode(Object fieldValue) {
            if (fieldValue == null) {
                return null;
            }
            if (fieldValue instanceof Date) {
                return fieldValue;
            }
            if (fieldValue instanceof Number) {
                return fieldValue;
            }
            try {
                return URLEncoder.encode((String)String.valueOf(fieldValue), (String)this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.debug((Object)("Unsupported Encoding: " + this.encoding));
                return null;
            }
        }

        public Object get(String col) throws IllegalStateException {
            return this.encode(this.wrappedDataRow.get(col));
        }

        public boolean isChanged(String name) {
            return this.wrappedDataRow.isChanged(name);
        }

        public String[] getColumnNames() {
            return this.wrappedDataRow.getColumnNames();
        }
    }
}

