/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import java.beans.PropertyEditor;
import java.sql.Clob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.formula.ErrorValue;

public class AttributeExpressionsEvaluator
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(AttributeExpressionsEvaluator.class);
    private LFUMap expressionsCache = new LFUMap(500);

    public void reportInitialized(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        super.reportInitialized(event);
        if (!event.getState().isSubReportEvent()) {
            ReportDefinition definition = event.getReport();
            this.evaluateElement(definition);
        }
    }

    protected void processRootBand(Band b) {
        NeedEvalResult needToRun = (NeedEvalResult)this.expressionsCache.get((Object)b.getObjectID());
        if (needToRun != null && !needToRun.isNeedToRun() && b.getChangeTracker() == needToRun.getChangeTracker()) {
            return;
        }
        boolean needToRunVal = this.processBand(b);
        this.expressionsCache.put((Object)b.getObjectID(), (Object)new NeedEvalResult(needToRunVal, b.getChangeTracker()));
    }

    private boolean processBand(Band b) {
        boolean hasAttrExpressions = this.evaluateElement(b);
        if (!b.isVisible()) {
            return hasAttrExpressions;
        }
        for (Element element : b.unsafeGetElementArray()) {
            if (element instanceof Band) {
                if (!this.processBand((Band)element)) continue;
                hasAttrExpressions = true;
                continue;
            }
            if (!this.evaluateElement(element)) continue;
            hasAttrExpressions = true;
        }
        if (b instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)((Object)b);
            SubReport[] reports = rlb.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport subReport = reports[i];
                if (!this.evaluateElement(subReport)) continue;
                hasAttrExpressions = true;
            }
        }
        return hasAttrExpressions;
    }

    protected void processGroup(Group group) {
        this.evaluateElement(group);
        this.evaluateElement(group.getBody());
        super.processGroup(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evaluateElement(ReportElement e) {
        if (e == null) {
            throw new NullPointerException();
        }
        String[] namespaces = e.getAttributeExpressionNamespaces();
        if (namespaces.length == 0) {
            return false;
        }
        ConverterRegistry instance = ConverterRegistry.getInstance();
        ElementMetaData metaData = e.getMetaData();
        boolean retval = false;
        for (int namespaceIdx = 0; namespaceIdx < namespaces.length; ++namespaceIdx) {
            String namespace = namespaces[namespaceIdx];
            String[] names = e.getAttributeExpressionNames(namespace);
            for (int nameIdx = 0; nameIdx < names.length; ++nameIdx) {
                AttributeMetaData attribute;
                String name = names[nameIdx];
                Expression ex = e.getAttributeExpression(namespace, name);
                if (ex == null || (attribute = metaData.getAttributeDescription(namespace, name)) != null && attribute.isDesignTimeValue()) continue;
                retval = true;
                ex.setRuntime(this.getRuntime());
                try {
                    Object value = this.evaluate(ex);
                    if (attribute == null) {
                        e.setAttribute(namespace, name, value);
                        continue;
                    }
                    Class type = attribute.getTargetType();
                    if (value == null || type.isAssignableFrom(value.getClass())) {
                        e.setAttribute(namespace, name, value);
                        continue;
                    }
                    if (value instanceof ErrorValue) {
                        e.setAttribute(namespace, name, null);
                        continue;
                    }
                    PropertyEditor propertyEditor = attribute.getEditor();
                    if (propertyEditor != null) {
                        propertyEditor.setAsText(String.valueOf(value));
                        e.setAttribute(namespace, name, propertyEditor.getValue());
                        continue;
                    }
                    try {
                        ValueConverter valueConverter = instance.getValueConverter(type);
                        if (type.isAssignableFrom(String.class)) {
                            e.setAttribute(namespace, name, value);
                            continue;
                        }
                        if (valueConverter != null) {
                            Object o = ConverterRegistry.toPropertyValue(String.valueOf(value), type);
                            e.setAttribute(namespace, name, o);
                            continue;
                        }
                        e.setAttribute(namespace, name, null);
                    }
                    catch (BeanException be) {
                        e.setAttribute(namespace, name, null);
                    }
                    continue;
                }
                catch (Exception exception) {
                    e.setAttribute(namespace, name, null);
                    continue;
                }
                finally {
                    ex.setRuntime(null);
                }
            }
        }
        return retval;
    }

    private Object evaluate(Expression ex) {
        Object retval = ex.getValue();
        if (retval instanceof Clob) {
            try {
                return IOUtils.getInstance().readClob((Clob)retval);
            }
            catch (Exception e) {
                return null;
            }
        }
        return retval;
    }

    public int getDependencyLevel() {
        return -2;
    }

    public Expression getInstance() {
        AttributeExpressionsEvaluator eval = (AttributeExpressionsEvaluator)super.getInstance();
        eval.expressionsCache = new LFUMap(500);
        return eval;
    }

    public int getProcessingPriority() {
        return 2000;
    }

    private static class NeedEvalResult {
        private boolean needToRun;
        private long changeTracker;

        private NeedEvalResult(boolean needToRun, long changeTracker) {
            this.needToRun = needToRun;
            this.changeTracker = changeTracker;
        }

        public boolean isNeedToRun() {
            return this.needToRun;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }
    }
}

