/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;

public class CellFormatFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private FormatSpecification formatSpecification;

    public int getProcessingPriority() {
        return 30000;
    }

    public int getDependencyLevel() {
        return -2;
    }

    protected void processRootBand(Band b) {
        if (!this.getRuntime().getExportDescriptor().startsWith("table/excel")) {
            return;
        }
        int elementCount = b.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Object attribute;
            ElementStyleSheet style;
            String oldFormat;
            Element e;
            ElementType source;
            ReportElement element = b.getElement(i);
            if (element instanceof Band) {
                this.processRootBand((Band)element);
                continue;
            }
            if (!(element instanceof Element) || !((source = (e = (Element)element).getElementType()) instanceof RawDataSource) || (oldFormat = (String)(style = element.getStyle()).getStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING)) != null && oldFormat.length() > 0 && !Boolean.TRUE.equals(attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "excel-cellformat-auto-compute"))) continue;
            RawDataSource rds = (RawDataSource)((Object)source);
            this.formatSpecification = rds.getFormatString(this.getRuntime(), e, this.formatSpecification);
            if (this.formatSpecification.getType() != 1 && this.formatSpecification.getType() != 2) continue;
            style.setStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING, this.formatSpecification.getFormatString());
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "excel-cellformat-auto-compute", Boolean.TRUE);
        }
    }

    public Expression getInstance() {
        CellFormatFunction instance = (CellFormatFunction)super.getInstance();
        instance.formatSpecification = null;
        return instance;
    }
}

