/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class SheetNameFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(SheetNameFunction.class);
    private static final String DECALRED_SHEETNAME_FUNCTION_KEY = "org.pentaho.reporting.engine.classic.core.targets.table.TableWriter.SheetNameFunction";
    private transient String lastValue;
    private transient String functionToCall;

    public void reportInitialized(ReportEvent event) {
        this.functionToCall = this.getReportConfiguration().getConfigProperty(DECALRED_SHEETNAME_FUNCTION_KEY);
        super.reportInitialized(event);
    }

    public int getDependencyLevel() {
        return -2;
    }

    public int getProcessingPriority() {
        return 3000;
    }

    protected void processRootBand(Band b) {
        this.processSheetName(b);
    }

    private void processSheetName(Element b) {
        this.lastValue = null;
        if (this.functionToCall == null) {
            return;
        }
        if (!this.getRuntime().getExportDescriptor().startsWith("table/")) {
            return;
        }
        Object value = this.getDataRow().get(this.functionToCall);
        if (value == null) {
            logger.debug((Object)("Cannot find the sheetname function/property referenced by '" + this.functionToCall + '\''));
        } else {
            this.lastValue = value.toString();
            b.getStyle().setStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME, this.lastValue);
        }
    }

    protected void processGroup(Group group) {
        super.processGroup(group);
        this.processSheetName(group);
        this.processSheetName(group.getBody());
    }

    public Object getValue() {
        return this.lastValue;
    }
}

