/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import java.sql.Clob;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.formula.ErrorValue;

public class StyleExpressionsEvaluator
extends AbstractElementFormatFunction
implements StructureFunction {
    private LFUMap expressionsCache = new LFUMap(500);

    public void reportInitialized(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        super.reportInitialized(event);
        if (!event.getState().isSubReportEvent()) {
            ReportDefinition definition = event.getReport();
            this.evaluateElement(definition);
        }
    }

    protected void processRootBand(Band b) {
        NeedEvalResult needToRun = (NeedEvalResult)this.expressionsCache.get((Object)b.getObjectID());
        if (needToRun != null && !needToRun.isNeedToRun() && b.getChangeTracker() == needToRun.getChangeTracker()) {
            return;
        }
        boolean needToRunVal = this.processBand(b);
        this.expressionsCache.put((Object)b.getObjectID(), (Object)new NeedEvalResult(needToRunVal, b.getChangeTracker()));
    }

    private boolean processBand(Band b) {
        boolean hasStyleExpressions = this.evaluateElement(b);
        if (!b.isVisible()) {
            return hasStyleExpressions;
        }
        for (Element element : b.unsafeGetElementArray()) {
            if (element instanceof Band) {
                if (!this.processBand((Band)element)) continue;
                hasStyleExpressions = true;
                continue;
            }
            if (!this.evaluateElement(element)) continue;
            hasStyleExpressions = true;
        }
        if (b instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)((Object)b);
            SubReport[] reports = rlb.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport subReport = reports[i];
                if (!this.evaluateElement(subReport)) continue;
                hasStyleExpressions = true;
            }
        }
        return hasStyleExpressions;
    }

    public int getProcessingPriority() {
        return 10000;
    }

    protected void processGroup(Group group) {
        this.evaluateElement(group);
        this.processRootBand(group.getHeader());
        this.evaluateElement(group.getBody());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evaluateElement(ReportElement e) {
        Map styleExpressions = e.getStyleExpressions();
        if (styleExpressions.isEmpty()) {
            return false;
        }
        boolean retval = false;
        ElementStyleSheet style = e.getStyle();
        for (Map.Entry entry : styleExpressions.entrySet()) {
            StyleKey key = (StyleKey)entry.getKey();
            Expression ex = (Expression)entry.getValue();
            if (ex == null) continue;
            retval = true;
            ex.setRuntime(this.getRuntime());
            try {
                Object value = this.evaluate(ex);
                if (value == null) {
                    style.setStyleProperty(key, null);
                    continue;
                }
                if (key.getValueType().isInstance(value)) {
                    style.setStyleProperty(key, value);
                    continue;
                }
                if (value instanceof ErrorValue) {
                    style.setStyleProperty(key, null);
                    continue;
                }
                ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(key.getValueType());
                if (valueConverter != null) {
                    Object o = ConverterRegistry.toPropertyValue(String.valueOf(value), key.getValueType());
                    style.setStyleProperty(key, o);
                    continue;
                }
                style.setStyleProperty(key, null);
            }
            catch (Exception exception) {
                style.setStyleProperty(key, null);
            }
            finally {
                ex.setRuntime(null);
            }
        }
        return retval;
    }

    private Object evaluate(Expression ex) {
        Object retval = ex.getValue();
        if (retval instanceof Clob) {
            try {
                return IOUtils.getInstance().readClob((Clob)retval);
            }
            catch (Exception e) {
                return null;
            }
        }
        return retval;
    }

    public int getDependencyLevel() {
        return -2;
    }

    public Expression getInstance() {
        StyleExpressionsEvaluator eval = (StyleExpressionsEvaluator)super.getInstance();
        eval.expressionsCache = new LFUMap(500);
        return eval;
    }

    private static class NeedEvalResult {
        private boolean needToRun;
        private long changeTracker;

        private NeedEvalResult(boolean needToRun, long changeTracker) {
            this.needToRun = needToRun;
            this.changeTracker = changeTracker;
        }

        public boolean isNeedToRun() {
            return this.needToRun;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }
    }
}

