/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class WizardItemHideFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(WizardItemHideFunction.class);
    private boolean pageStarted;
    private LFUMap expressionsCache = new LFUMap(500);

    protected void processRootBand(Band b) {
        NeedEvalResult needToRun = (NeedEvalResult)this.expressionsCache.get((Object)b.getObjectID());
        if (needToRun != null && !needToRun.isNeedToRun() && b.getChangeTracker() == needToRun.getChangeTracker()) {
            return;
        }
        boolean needToRunVal = this.processBand(b);
        this.expressionsCache.put((Object)b.getObjectID(), (Object)new NeedEvalResult(needToRunVal, b.getChangeTracker()));
    }

    private boolean processBand(Band b) {
        boolean hasAttrExpressions = this.evaluateElement(b);
        if (!b.isVisible()) {
            return hasAttrExpressions;
        }
        for (Element element : b.unsafeGetElementArray()) {
            if (element instanceof Band) {
                if (!this.processBand((Band)element)) continue;
                hasAttrExpressions = true;
                continue;
            }
            if (!this.evaluateElement(element)) continue;
            hasAttrExpressions = true;
        }
        if (b instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)((Object)b);
            SubReport[] reports = rlb.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport subReport = reports[i];
                if (!this.evaluateElement(subReport)) continue;
                hasAttrExpressions = true;
            }
        }
        return hasAttrExpressions;
    }

    public int getProcessingPriority() {
        return 6000;
    }

    protected boolean evaluateElement(Element e) {
        if (e == null) {
            throw new NullPointerException();
        }
        boolean retval = false;
        Object maybeShowChanging = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "only-show-changing-values");
        if (Boolean.TRUE.equals(maybeShowChanging)) {
            Object field = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for");
            if (field == null) {
                field = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
            }
            if (field != null) {
                String fieldText = String.valueOf(field);
                if (this.pageStarted || this.getDataRow().isChanged(fieldText)) {
                    e.setVisible(true);
                } else {
                    e.setVisible(false);
                }
                retval = true;
            }
        }
        return retval;
    }

    public int getDependencyLevel() {
        return -2;
    }

    public Expression getInstance() {
        WizardItemHideFunction eval = (WizardItemHideFunction)super.getInstance();
        eval.expressionsCache = new LFUMap(500);
        return eval;
    }

    public void pageStarted(ReportEvent event) {
        this.pageStarted = true;
        super.pageStarted(event);
    }

    public void itemsStarted(ReportEvent event) {
        this.pageStarted = true;
        super.itemsStarted(event);
    }

    public void itemsAdvanced(ReportEvent event) {
        super.itemsAdvanced(event);
        this.pageStarted = false;
    }

    private static class NeedEvalResult {
        private boolean needToRun;
        private long changeTracker;

        private NeedEvalResult(boolean needToRun, long changeTracker) {
            this.needToRun = needToRun;
            this.changeTracker = changeTracker;
        }

        public boolean isNeedToRun() {
            return this.needToRun;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }
    }
}

