/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.imagemap;

import java.io.Serializable;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class ImageMap
implements Serializable {
    private AttributeMap attributes = new AttributeMap();
    private ArrayList mapEntries = new ArrayList();

    public void addMapEntry(ImageMapEntry mapEntry) {
        if (mapEntry == null) {
            throw new NullPointerException();
        }
        this.mapEntries.add(mapEntry);
    }

    public ImageMapEntry[] getMapEntries() {
        return this.mapEntries.toArray(new ImageMapEntry[this.mapEntries.size()]);
    }

    public int getMapEntryCount() {
        return this.mapEntries.size();
    }

    public ImageMapEntry getMapEntry(int index) {
        return (ImageMapEntry)this.mapEntries.get(index);
    }

    public void setAttribute(String namespace, String attribute, String value) {
        this.attributes.setAttribute(namespace, attribute, (Object)value);
    }

    public String getAttribute(String namespace, String attribute) {
        return (String)this.attributes.getAttribute(namespace, attribute);
    }

    public String[] getNames(String namespace) {
        return this.attributes.getNames(namespace);
    }

    public String[] getNameSpaces() {
        return this.attributes.getNameSpaces();
    }

    public ImageMapEntry[] getEntriesForPoint(float x, float y) {
        ArrayList<ImageMapEntry> list = new ArrayList<ImageMapEntry>();
        for (int i = 0; i < this.mapEntries.size(); ++i) {
            ImageMapEntry entry = (ImageMapEntry)this.mapEntries.get(i);
            if (!entry.contains(x, y)) continue;
            list.add(entry);
        }
        return list.toArray(new ImageMapEntry[list.size()]);
    }
}

